/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;

public class DateUtils {
    protected final SimpleDateFormat iso8601DateParser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    protected final SimpleDateFormat alternateIso8601DateParser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    protected final SimpleDateFormat rfc822DateParser = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);

    public DateUtils() {
        this.iso8601DateParser.setTimeZone(new SimpleTimeZone(0, "GMT"));
        this.rfc822DateParser.setTimeZone(new SimpleTimeZone(0, "GMT"));
        this.alternateIso8601DateParser.setTimeZone(new SimpleTimeZone(0, "GMT"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parseIso8601Date(String dateString) throws ParseException {
        try {
            SimpleDateFormat simpleDateFormat = this.iso8601DateParser;
            synchronized (simpleDateFormat) {
                return this.iso8601DateParser.parse(dateString);
            }
        }
        catch (ParseException e) {
            SimpleDateFormat simpleDateFormat = this.alternateIso8601DateParser;
            synchronized (simpleDateFormat) {
                return this.alternateIso8601DateParser.parse(dateString);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatIso8601Date(Date date) {
        SimpleDateFormat simpleDateFormat = this.iso8601DateParser;
        synchronized (simpleDateFormat) {
            return this.iso8601DateParser.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parseRfc822Date(String dateString) throws ParseException {
        SimpleDateFormat simpleDateFormat = this.rfc822DateParser;
        synchronized (simpleDateFormat) {
            return this.rfc822DateParser.parse(dateString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatRfc822Date(Date date) {
        SimpleDateFormat simpleDateFormat = this.rfc822DateParser;
        synchronized (simpleDateFormat) {
            return this.rfc822DateParser.format(date);
        }
    }
}

