/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model;

import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.StatisticSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricDatum {
    private String metricName;
    private List<Dimension> dimensions;
    private Date timestamp;
    private Double value;
    private StatisticSet statisticValues;
    private String unit;

    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public MetricDatum withMetricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    public List<Dimension> getDimensions() {
        if (this.dimensions == null) {
            this.dimensions = new ArrayList<Dimension>();
        }
        return this.dimensions;
    }

    public void setDimensions(Collection<Dimension> dimensions) {
        ArrayList<Dimension> dimensionsCopy = new ArrayList<Dimension>();
        if (dimensions != null) {
            dimensionsCopy.addAll(dimensions);
        }
        this.dimensions = dimensionsCopy;
    }

    public MetricDatum withDimensions(Dimension ... dimensions) {
        if (this.getDimensions() == null) {
            this.setDimensions(new ArrayList<Dimension>());
        }
        for (Dimension value : dimensions) {
            this.getDimensions().add(value);
        }
        return this;
    }

    public MetricDatum withDimensions(Collection<Dimension> dimensions) {
        ArrayList<Dimension> dimensionsCopy = new ArrayList<Dimension>();
        if (dimensions != null) {
            dimensionsCopy.addAll(dimensions);
        }
        this.dimensions = dimensionsCopy;
        return this;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public MetricDatum withTimestamp(Date timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public MetricDatum withValue(Double value) {
        this.value = value;
        return this;
    }

    public StatisticSet getStatisticValues() {
        return this.statisticValues;
    }

    public void setStatisticValues(StatisticSet statisticValues) {
        this.statisticValues = statisticValues;
    }

    public MetricDatum withStatisticValues(StatisticSet statisticValues) {
        this.statisticValues = statisticValues;
        return this;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public MetricDatum withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("MetricName: " + this.metricName + ", ");
        sb.append("Dimensions: " + this.dimensions + ", ");
        sb.append("Timestamp: " + this.timestamp + ", ");
        sb.append("Value: " + this.value + ", ");
        sb.append("StatisticValues: " + this.statisticValues + ", ");
        sb.append("Unit: " + this.unit + ", ");
        sb.append("}");
        return sb.toString();
    }
}

