/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.ListInvalidationsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListInvalidationsRequestMarshaller
implements Marshaller<Request<ListInvalidationsRequest>, ListInvalidationsRequest> {
    @Override
    public Request<ListInvalidationsRequest> marshall(ListInvalidationsRequest listInvalidationsRequest) {
        if (listInvalidationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListInvalidationsRequest> request = new DefaultRequest<ListInvalidationsRequest>(listInvalidationsRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "2010-11-01/distribution/{DistributionId}/invalidation?Marker={Marker}&MaxItems={MaxItems}";
        uriResourcePath = uriResourcePath.replace("{DistributionId}", this.getString(listInvalidationsRequest.getDistributionId()));
        uriResourcePath = uriResourcePath.replace("{Marker}", this.getString(listInvalidationsRequest.getMarker()));
        uriResourcePath = uriResourcePath.replace("{MaxItems}", this.getString(listInvalidationsRequest.getMaxItems()));
        request.setResourcePath(uriResourcePath);
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter(stringWriter, "http://cloudfront.amazonaws.com/doc/2010-11-01/");
        try {
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
        }
        catch (UnsupportedEncodingException e) {
            throw new AmazonClientException("Unable to marshall request to XML", e);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

