/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.util.json.JSONException;
import com.amazonaws.util.json.JSONObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonErrorResponseHandler
implements HttpResponseHandler<AmazonServiceException> {
    @Override
    public AmazonServiceException handle(HttpResponse response) throws Exception {
        String type;
        int separator;
        JSONObject jsonErrorMessage = new JSONObject(this.readStreamContents(response.getContent()));
        String message = null;
        try {
            message = jsonErrorMessage.getString("message");
        }
        catch (JSONException jsone) {
            // empty catch block
        }
        AmazonServiceException exception = new AmazonServiceException(message);
        exception.setServiceName(response.getRequest().getServiceName());
        if (jsonErrorMessage.getString("__type") != null && (separator = (type = jsonErrorMessage.getString("__type")).lastIndexOf("#")) > 0) {
            exception.setErrorCode(type.substring(separator + 1));
        }
        exception.setStatusCode(response.getStatusCode());
        if (response.getStatusCode() < 500) {
            exception.setErrorType(AmazonServiceException.ErrorType.Client);
        } else {
            exception.setErrorType(AmazonServiceException.ErrorType.Service);
        }
        for (Map.Entry<String, String> headerEntry : response.getHeaders().entrySet()) {
            if (!headerEntry.getKey().equalsIgnoreCase("X-Amzn-RequestId")) continue;
            exception.setRequestId(headerEntry.getValue());
        }
        return exception;
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }

    private String readStreamContents(InputStream stream) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            return sb.toString();
        }
        catch (Exception e) {
            try {
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AmazonClientException("Unable to read error response: " + e.getMessage(), e);
        }
    }
}

