/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddInstanceGroupsRequestMarshaller
implements Marshaller<Request<AddInstanceGroupsRequest>, AddInstanceGroupsRequest> {
    @Override
    public Request<AddInstanceGroupsRequest> marshall(AddInstanceGroupsRequest addInstanceGroupsRequest) {
        DefaultRequest<AddInstanceGroupsRequest> request = new DefaultRequest<AddInstanceGroupsRequest>(addInstanceGroupsRequest, "AmazonElasticMapReduce");
        request.addParameter("Action", "AddInstanceGroups");
        request.addParameter("Version", "2009-03-31");
        if (addInstanceGroupsRequest != null) {
            List<InstanceGroupConfig> instanceGroupsList = addInstanceGroupsRequest.getInstanceGroups();
            int instanceGroupsListIndex = 1;
            for (InstanceGroupConfig instanceGroupsListValue : instanceGroupsList) {
                if (instanceGroupsListValue != null && instanceGroupsListValue.getName() != null) {
                    request.addParameter("InstanceGroups.member." + instanceGroupsListIndex + ".Name", StringUtils.fromString(instanceGroupsListValue.getName()));
                }
                if (instanceGroupsListValue != null && instanceGroupsListValue.getMarket() != null) {
                    request.addParameter("InstanceGroups.member." + instanceGroupsListIndex + ".Market", StringUtils.fromString(instanceGroupsListValue.getMarket()));
                }
                if (instanceGroupsListValue != null && instanceGroupsListValue.getInstanceRole() != null) {
                    request.addParameter("InstanceGroups.member." + instanceGroupsListIndex + ".InstanceRole", StringUtils.fromString(instanceGroupsListValue.getInstanceRole()));
                }
                if (instanceGroupsListValue != null && instanceGroupsListValue.getInstanceType() != null) {
                    request.addParameter("InstanceGroups.member." + instanceGroupsListIndex + ".InstanceType", StringUtils.fromString(instanceGroupsListValue.getInstanceType()));
                }
                if (instanceGroupsListValue != null && instanceGroupsListValue.getInstanceCount() != null) {
                    request.addParameter("InstanceGroups.member." + instanceGroupsListIndex + ".InstanceCount", StringUtils.fromInteger(instanceGroupsListValue.getInstanceCount()));
                }
                ++instanceGroupsListIndex;
            }
        }
        if (addInstanceGroupsRequest != null && addInstanceGroupsRequest.getJobFlowId() != null) {
            request.addParameter("JobFlowId", StringUtils.fromString(addInstanceGroupsRequest.getJobFlowId()));
        }
        return request;
    }
}

