/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.util;

import com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig;
import java.util.ArrayList;

public class StepFactory {
    private final String bucket;

    public StepFactory() {
        this("us-east-1.elasticmapreduce");
    }

    public StepFactory(String bucket) {
        this.bucket = bucket;
    }

    public HadoopJarStepConfig newScriptRunnerStep(String script, String ... args) {
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add(script);
        for (String arg : args) {
            argsList.add(arg);
        }
        return new HadoopJarStepConfig().withJar("s3://" + this.bucket + "/libs/script-runner/script-runner.jar").withArgs(argsList);
    }

    public HadoopJarStepConfig newEnableDebuggingStep() {
        return this.newScriptRunnerStep("s3://" + this.bucket + "/libs/state-pusher/0.1/fetch", new String[0]);
    }

    public HadoopJarStepConfig newInstallHiveStep() {
        return this.newHivePigStep("hive", "--install-hive");
    }

    public HadoopJarStepConfig newRunHiveScriptStep(String script, String ... args) {
        String[] argsArray = new String[args.length + 4];
        argsArray[0] = "--run-hive-script";
        argsArray[1] = "--args";
        argsArray[2] = "-f";
        argsArray[3] = script;
        System.arraycopy(args, 0, argsArray, 4, args.length);
        return this.newHivePigStep("hive", argsArray);
    }

    public HadoopJarStepConfig newInstallPigStep() {
        return this.newHivePigStep("pig", "--install-pig");
    }

    public HadoopJarStepConfig newRunPigScriptStep(String script, String ... args) {
        String[] argsArray = new String[args.length + 4];
        argsArray[0] = "--run-pig-script";
        argsArray[1] = "--args";
        argsArray[2] = "-f";
        argsArray[3] = script;
        System.arraycopy(args, 0, argsArray, 4, args.length);
        return this.newHivePigStep("pig", argsArray);
    }

    private HadoopJarStepConfig newHivePigStep(String type, String ... args) {
        String[] argsArray = new String[args.length + 2];
        argsArray[0] = "--base-path";
        argsArray[1] = "s3://" + this.bucket + "/libs/" + type + "/";
        System.arraycopy(args, 0, argsArray, 2, args.length);
        return this.newScriptRunnerStep("s3://" + this.bucket + "/libs/" + type + "/" + type + "-script", argsArray);
    }
}

