/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeSpotPriceHistoryRequestMarshaller
implements Marshaller<Request<DescribeSpotPriceHistoryRequest>, DescribeSpotPriceHistoryRequest> {
    @Override
    public Request<DescribeSpotPriceHistoryRequest> marshall(DescribeSpotPriceHistoryRequest describeSpotPriceHistoryRequest) {
        DefaultRequest<DescribeSpotPriceHistoryRequest> request = new DefaultRequest<DescribeSpotPriceHistoryRequest>(describeSpotPriceHistoryRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeSpotPriceHistory");
        request.addParameter("Version", "2010-06-15");
        if (describeSpotPriceHistoryRequest != null && describeSpotPriceHistoryRequest.getStartTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate(describeSpotPriceHistoryRequest.getStartTime()));
        }
        if (describeSpotPriceHistoryRequest != null && describeSpotPriceHistoryRequest.getEndTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate(describeSpotPriceHistoryRequest.getEndTime()));
        }
        if (describeSpotPriceHistoryRequest != null) {
            List<String> instanceTypesList = describeSpotPriceHistoryRequest.getInstanceTypes();
            int instanceTypesListIndex = 1;
            for (String instanceTypesListValue : instanceTypesList) {
                if (instanceTypesListValue != null) {
                    request.addParameter("InstanceType." + instanceTypesListIndex, StringUtils.fromString(instanceTypesListValue));
                }
                ++instanceTypesListIndex;
            }
        }
        if (describeSpotPriceHistoryRequest != null) {
            List<String> productDescriptionsList = describeSpotPriceHistoryRequest.getProductDescriptions();
            int productDescriptionsListIndex = 1;
            for (String productDescriptionsListValue : productDescriptionsList) {
                if (productDescriptionsListValue != null) {
                    request.addParameter("ProductDescription." + productDescriptionsListIndex, StringUtils.fromString(productDescriptionsListValue));
                }
                ++productDescriptionsListIndex;
            }
        }
        return request;
    }
}

