/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.Request;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.SignatureVersion;
import com.amazonaws.auth.Signer;
import com.amazonaws.auth.SigningAlgorithm;
import com.amazonaws.util.HttpUtils;
import java.net.URI;
import java.security.SignatureException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryStringSigner<T>
implements Signer<T> {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private final AWSCredentials credentials;

    public QueryStringSigner(AWSCredentials credentials) {
        this.credentials = credentials;
    }

    public void sign(Request<T> request) throws SignatureException {
        this.sign(request, SignatureVersion.V2, SigningAlgorithm.HmacSHA256);
    }

    @Override
    public void sign(Request<T> request, SignatureVersion version, SigningAlgorithm algorithm) throws SignatureException {
        request.addParameter("AWSAccessKeyId", this.credentials.getAWSAccessKeyId());
        request.addParameter("SignatureVersion", version.toString());
        request.addParameter("Timestamp", this.getFormattedTimestamp());
        String stringToSign = null;
        switch (version) {
            case V1: {
                stringToSign = this.calculateStringToSignV1(request.getParameters());
                break;
            }
            case V2: {
                request.addParameter("SignatureMethod", algorithm.toString());
                stringToSign = this.calculateStringToSignV2(request.getEndpoint(), request.getParameters());
                break;
            }
            default: {
                throw new SignatureException("Invalid Signature Version specified");
            }
        }
        String signatureValue = this.sign(stringToSign, this.credentials.getAWSSecretKey(), algorithm);
        request.addParameter("Signature", signatureValue);
    }

    private String sign(String data, String key, SigningAlgorithm algorithm) throws SignatureException {
        try {
            Mac mac = Mac.getInstance(algorithm.toString());
            mac.init(new SecretKeySpec(key.getBytes(), algorithm.toString()));
            byte[] signature = Base64.encodeBase64((byte[])mac.doFinal(data.getBytes(DEFAULT_ENCODING)));
            return new String(signature);
        }
        catch (Exception e) {
            throw new SignatureException("Failed to generate signature: " + e.getMessage(), e);
        }
    }

    private String calculateStringToSignV1(Map<String, String> parameters) {
        StringBuilder data = new StringBuilder();
        TreeMap<String, String> sorted = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        sorted.putAll(parameters);
        for (String key : sorted.keySet()) {
            data.append(key);
            data.append((String)sorted.get(key));
        }
        return data.toString();
    }

    private String calculateStringToSignV2(URI endpoint, Map<String, String> parameters) throws SignatureException {
        StringBuilder data = new StringBuilder();
        data.append("POST");
        data.append("\n");
        data.append(endpoint.getAuthority().toLowerCase());
        data.append("\n");
        String uri = endpoint.getPath();
        if (uri == null || uri.length() == 0) {
            uri = "/";
        }
        data.append(HttpUtils.urlEncode(uri, true));
        data.append("\n");
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        sorted.putAll(parameters);
        Iterator pairs = sorted.entrySet().iterator();
        while (pairs.hasNext()) {
            Map.Entry pair = pairs.next();
            String key = (String)pair.getKey();
            String value = (String)pair.getValue();
            data.append(HttpUtils.urlEncode(key, false));
            data.append("=");
            data.append(HttpUtils.urlEncode(value, false));
            if (!pairs.hasNext()) continue;
            data.append("&");
        }
        return data.toString();
    }

    private String getFormattedTimestamp() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(new Date());
    }
}

