/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.Volume;
import com.amazonaws.services.ec2.model.transform.VolumeAttachmentUnmarshaller;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VolumeUnmarshaller
implements Unmarshaller<Volume, Node> {
    @Override
    public Volume unmarshall(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        Volume volume = new Volume();
        Node volumeIdNode = XpathUtils.asNode("volumeId", node);
        volume.setVolumeId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(volumeIdNode));
        Node sizeNode = XpathUtils.asNode("size", node);
        volume.setSize(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(sizeNode));
        Node snapshotIdNode = XpathUtils.asNode("snapshotId", node);
        volume.setSnapshotId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(snapshotIdNode));
        Node availabilityZoneNode = XpathUtils.asNode("availabilityZone", node);
        volume.setAvailabilityZone(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(availabilityZoneNode));
        Node stateNode = XpathUtils.asNode("status", node);
        volume.setState(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(stateNode));
        Node createTimeNode = XpathUtils.asNode("createTime", node);
        volume.setCreateTime(new SimpleTypeUnmarshallers.DateUnmarshaller().unmarshall(createTimeNode));
        NodeList attachmentsNodes = XpathUtils.asNodeList("attachmentSet/item", node);
        for (int attachmentsIndex = 0; attachmentsIndex < XpathUtils.nodeLength(attachmentsNodes); ++attachmentsIndex) {
            Node attachmentsNode = attachmentsNodes.item(attachmentsIndex);
            volume.getAttachments().add(new VolumeAttachmentUnmarshaller().unmarshall(attachmentsNode));
            attachmentsNode.getParentNode().removeChild(attachmentsNode);
        }
        return volume;
    }
}

