/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.Image;
import com.amazonaws.services.ec2.model.transform.BlockDeviceMappingUnmarshaller;
import com.amazonaws.services.ec2.model.transform.ProductCodeUnmarshaller;
import com.amazonaws.services.ec2.model.transform.StateReasonUnmarshaller;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageUnmarshaller
implements Unmarshaller<Image, Node> {
    @Override
    public Image unmarshall(Node node) throws Exception {
        Image image = new Image();
        Node imageIdNode = XpathUtils.asNode("imageId", node);
        image.setImageId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(imageIdNode));
        Node imageLocationNode = XpathUtils.asNode("imageLocation", node);
        image.setImageLocation(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(imageLocationNode));
        Node stateNode = XpathUtils.asNode("imageState", node);
        image.setState(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(stateNode));
        Node ownerIdNode = XpathUtils.asNode("imageOwnerId", node);
        image.setOwnerId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(ownerIdNode));
        Node publicValueNode = XpathUtils.asNode("isPublic", node);
        image.setPublic(new SimpleTypeUnmarshallers.BooleanUnmarshaller().unmarshall(publicValueNode));
        NodeList productCodesNodes = XpathUtils.asNodeList("productCodes/item", node);
        for (int productCodesIndex = 0; productCodesIndex < XpathUtils.nodeLength(productCodesNodes); ++productCodesIndex) {
            Node productCodesNode = productCodesNodes.item(productCodesIndex);
            image.getProductCodes().add(new ProductCodeUnmarshaller().unmarshall(productCodesNode));
            productCodesNode.getParentNode().removeChild(productCodesNode);
        }
        Node architectureNode = XpathUtils.asNode("architecture", node);
        image.setArchitecture(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(architectureNode));
        Node imageTypeNode = XpathUtils.asNode("imageType", node);
        image.setImageType(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(imageTypeNode));
        Node kernelIdNode = XpathUtils.asNode("kernelId", node);
        image.setKernelId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(kernelIdNode));
        Node ramdiskIdNode = XpathUtils.asNode("ramdiskId", node);
        image.setRamdiskId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(ramdiskIdNode));
        Node platformNode = XpathUtils.asNode("platform", node);
        image.setPlatform(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(platformNode));
        Node stateReasonNode = XpathUtils.asNode("stateReason", node);
        image.setStateReason(new StateReasonUnmarshaller().unmarshall(stateReasonNode));
        Node imageOwnerAliasNode = XpathUtils.asNode("imageOwnerAlias", node);
        image.setImageOwnerAlias(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(imageOwnerAliasNode));
        Node nameNode = XpathUtils.asNode("name", node);
        image.setName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(nameNode));
        Node descriptionNode = XpathUtils.asNode("description", node);
        image.setDescription(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(descriptionNode));
        Node rootDeviceTypeNode = XpathUtils.asNode("rootDeviceType", node);
        image.setRootDeviceType(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(rootDeviceTypeNode));
        Node rootDeviceNameNode = XpathUtils.asNode("rootDeviceName", node);
        image.setRootDeviceName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(rootDeviceNameNode));
        NodeList blockDeviceMappingsNodes = XpathUtils.asNodeList("blockDeviceMapping/item", node);
        for (int blockDeviceMappingsIndex = 0; blockDeviceMappingsIndex < XpathUtils.nodeLength(blockDeviceMappingsNodes); ++blockDeviceMappingsIndex) {
            Node blockDeviceMappingsNode = blockDeviceMappingsNodes.item(blockDeviceMappingsIndex);
            image.getBlockDeviceMappings().add(new BlockDeviceMappingUnmarshaller().unmarshall(blockDeviceMappingsNode));
            blockDeviceMappingsNode.getParentNode().removeChild(blockDeviceMappingsNode);
        }
        return image;
    }
}

