/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.xray.model.EdgeStatistics;
import com.amazonaws.services.xray.model.HistogramEntry;
import com.amazonaws.services.xray.model.ServiceStatistics;
import com.amazonaws.services.xray.model.transform.TimeSeriesServiceStatisticsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class TimeSeriesServiceStatistics
implements Serializable,
Cloneable,
StructuredPojo {
    private Date timestamp;
    private EdgeStatistics edgeSummaryStatistics;
    private ServiceStatistics serviceSummaryStatistics;
    private List<HistogramEntry> responseTimeHistogram;

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public TimeSeriesServiceStatistics withTimestamp(Date timestamp) {
        this.setTimestamp(timestamp);
        return this;
    }

    public void setEdgeSummaryStatistics(EdgeStatistics edgeSummaryStatistics) {
        this.edgeSummaryStatistics = edgeSummaryStatistics;
    }

    public EdgeStatistics getEdgeSummaryStatistics() {
        return this.edgeSummaryStatistics;
    }

    public TimeSeriesServiceStatistics withEdgeSummaryStatistics(EdgeStatistics edgeSummaryStatistics) {
        this.setEdgeSummaryStatistics(edgeSummaryStatistics);
        return this;
    }

    public void setServiceSummaryStatistics(ServiceStatistics serviceSummaryStatistics) {
        this.serviceSummaryStatistics = serviceSummaryStatistics;
    }

    public ServiceStatistics getServiceSummaryStatistics() {
        return this.serviceSummaryStatistics;
    }

    public TimeSeriesServiceStatistics withServiceSummaryStatistics(ServiceStatistics serviceSummaryStatistics) {
        this.setServiceSummaryStatistics(serviceSummaryStatistics);
        return this;
    }

    public List<HistogramEntry> getResponseTimeHistogram() {
        return this.responseTimeHistogram;
    }

    public void setResponseTimeHistogram(Collection<HistogramEntry> responseTimeHistogram) {
        if (responseTimeHistogram == null) {
            this.responseTimeHistogram = null;
            return;
        }
        this.responseTimeHistogram = new ArrayList<HistogramEntry>(responseTimeHistogram);
    }

    public TimeSeriesServiceStatistics withResponseTimeHistogram(HistogramEntry ... responseTimeHistogram) {
        if (this.responseTimeHistogram == null) {
            this.setResponseTimeHistogram(new ArrayList<HistogramEntry>(responseTimeHistogram.length));
        }
        for (HistogramEntry ele : responseTimeHistogram) {
            this.responseTimeHistogram.add(ele);
        }
        return this;
    }

    public TimeSeriesServiceStatistics withResponseTimeHistogram(Collection<HistogramEntry> responseTimeHistogram) {
        this.setResponseTimeHistogram(responseTimeHistogram);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTimestamp() != null) {
            sb.append("Timestamp: ").append(this.getTimestamp()).append(",");
        }
        if (this.getEdgeSummaryStatistics() != null) {
            sb.append("EdgeSummaryStatistics: ").append(this.getEdgeSummaryStatistics()).append(",");
        }
        if (this.getServiceSummaryStatistics() != null) {
            sb.append("ServiceSummaryStatistics: ").append(this.getServiceSummaryStatistics()).append(",");
        }
        if (this.getResponseTimeHistogram() != null) {
            sb.append("ResponseTimeHistogram: ").append(this.getResponseTimeHistogram());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesServiceStatistics)) {
            return false;
        }
        TimeSeriesServiceStatistics other = (TimeSeriesServiceStatistics)obj;
        if (other.getTimestamp() == null ^ this.getTimestamp() == null) {
            return false;
        }
        if (other.getTimestamp() != null && !other.getTimestamp().equals(this.getTimestamp())) {
            return false;
        }
        if (other.getEdgeSummaryStatistics() == null ^ this.getEdgeSummaryStatistics() == null) {
            return false;
        }
        if (other.getEdgeSummaryStatistics() != null && !other.getEdgeSummaryStatistics().equals(this.getEdgeSummaryStatistics())) {
            return false;
        }
        if (other.getServiceSummaryStatistics() == null ^ this.getServiceSummaryStatistics() == null) {
            return false;
        }
        if (other.getServiceSummaryStatistics() != null && !other.getServiceSummaryStatistics().equals(this.getServiceSummaryStatistics())) {
            return false;
        }
        if (other.getResponseTimeHistogram() == null ^ this.getResponseTimeHistogram() == null) {
            return false;
        }
        return other.getResponseTimeHistogram() == null || other.getResponseTimeHistogram().equals(this.getResponseTimeHistogram());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTimestamp() == null ? 0 : this.getTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getEdgeSummaryStatistics() == null ? 0 : this.getEdgeSummaryStatistics().hashCode());
        hashCode = 31 * hashCode + (this.getServiceSummaryStatistics() == null ? 0 : this.getServiceSummaryStatistics().hashCode());
        hashCode = 31 * hashCode + (this.getResponseTimeHistogram() == null ? 0 : this.getResponseTimeHistogram().hashCode());
        return hashCode;
    }

    public TimeSeriesServiceStatistics clone() {
        try {
            return (TimeSeriesServiceStatistics)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimeSeriesServiceStatisticsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

