/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.xray.model.GetTraceSummariesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetTraceSummariesRequestMarshaller
implements Marshaller<Request<GetTraceSummariesRequest>, GetTraceSummariesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetTraceSummariesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetTraceSummariesRequest> marshall(GetTraceSummariesRequest getTraceSummariesRequest) {
        if (getTraceSummariesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getTraceSummariesRequest, "AWSXRay");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/TraceSummaries";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getTraceSummariesRequest.getStartTime() != null) {
                jsonGenerator.writeFieldName("StartTime").writeValue(getTraceSummariesRequest.getStartTime());
            }
            if (getTraceSummariesRequest.getEndTime() != null) {
                jsonGenerator.writeFieldName("EndTime").writeValue(getTraceSummariesRequest.getEndTime());
            }
            if (getTraceSummariesRequest.getSampling() != null) {
                jsonGenerator.writeFieldName("Sampling").writeValue(getTraceSummariesRequest.getSampling().booleanValue());
            }
            if (getTraceSummariesRequest.getFilterExpression() != null) {
                jsonGenerator.writeFieldName("FilterExpression").writeValue(getTraceSummariesRequest.getFilterExpression());
            }
            if (getTraceSummariesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(getTraceSummariesRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

