/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.xray.AWSXRayAsync;
import com.amazonaws.services.xray.AWSXRayAsyncClientBuilder;
import com.amazonaws.services.xray.AWSXRayClient;
import com.amazonaws.services.xray.model.BatchGetTracesRequest;
import com.amazonaws.services.xray.model.BatchGetTracesResult;
import com.amazonaws.services.xray.model.CreateGroupRequest;
import com.amazonaws.services.xray.model.CreateGroupResult;
import com.amazonaws.services.xray.model.CreateSamplingRuleRequest;
import com.amazonaws.services.xray.model.CreateSamplingRuleResult;
import com.amazonaws.services.xray.model.DeleteGroupRequest;
import com.amazonaws.services.xray.model.DeleteGroupResult;
import com.amazonaws.services.xray.model.DeleteSamplingRuleRequest;
import com.amazonaws.services.xray.model.DeleteSamplingRuleResult;
import com.amazonaws.services.xray.model.GetEncryptionConfigRequest;
import com.amazonaws.services.xray.model.GetEncryptionConfigResult;
import com.amazonaws.services.xray.model.GetGroupRequest;
import com.amazonaws.services.xray.model.GetGroupResult;
import com.amazonaws.services.xray.model.GetGroupsRequest;
import com.amazonaws.services.xray.model.GetGroupsResult;
import com.amazonaws.services.xray.model.GetSamplingRulesRequest;
import com.amazonaws.services.xray.model.GetSamplingRulesResult;
import com.amazonaws.services.xray.model.GetSamplingStatisticSummariesRequest;
import com.amazonaws.services.xray.model.GetSamplingStatisticSummariesResult;
import com.amazonaws.services.xray.model.GetSamplingTargetsRequest;
import com.amazonaws.services.xray.model.GetSamplingTargetsResult;
import com.amazonaws.services.xray.model.GetServiceGraphRequest;
import com.amazonaws.services.xray.model.GetServiceGraphResult;
import com.amazonaws.services.xray.model.GetTraceGraphRequest;
import com.amazonaws.services.xray.model.GetTraceGraphResult;
import com.amazonaws.services.xray.model.GetTraceSummariesRequest;
import com.amazonaws.services.xray.model.GetTraceSummariesResult;
import com.amazonaws.services.xray.model.PutEncryptionConfigRequest;
import com.amazonaws.services.xray.model.PutEncryptionConfigResult;
import com.amazonaws.services.xray.model.PutTelemetryRecordsRequest;
import com.amazonaws.services.xray.model.PutTelemetryRecordsResult;
import com.amazonaws.services.xray.model.PutTraceSegmentsRequest;
import com.amazonaws.services.xray.model.PutTraceSegmentsResult;
import com.amazonaws.services.xray.model.UpdateGroupRequest;
import com.amazonaws.services.xray.model.UpdateGroupResult;
import com.amazonaws.services.xray.model.UpdateSamplingRuleRequest;
import com.amazonaws.services.xray.model.UpdateSamplingRuleResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSXRayAsyncClient
extends AWSXRayClient
implements AWSXRayAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSXRayAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSXRayAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSXRayAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSXRayAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSXRayAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSXRayAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSXRayAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSXRayAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSXRayAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AWSXRayAsyncClientBuilder asyncBuilder() {
        return AWSXRayAsyncClientBuilder.standard();
    }

    AWSXRayAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchGetTracesResult> batchGetTracesAsync(BatchGetTracesRequest request) {
        return this.batchGetTracesAsync(request, null);
    }

    @Override
    public Future<BatchGetTracesResult> batchGetTracesAsync(BatchGetTracesRequest request, final AsyncHandler<BatchGetTracesRequest, BatchGetTracesResult> asyncHandler) {
        final BatchGetTracesRequest finalRequest = (BatchGetTracesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetTracesResult>(){

            @Override
            public BatchGetTracesResult call() throws Exception {
                BatchGetTracesResult result = null;
                try {
                    result = AWSXRayAsyncClient.this.executeBatchGetTraces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateGroupResult> createGroupAsync(CreateGroupRequest request) {
        return this.createGroupAsync(request, null);
    }

    @Override
    public Future<CreateGroupResult> createGroupAsync(CreateGroupRequest request, final AsyncHandler<CreateGroupRequest, CreateGroupResult> asyncHandler) {
        final CreateGroupRequest finalRequest = (CreateGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateGroupResult>(){

            @Override
            public CreateGroupResult call() throws Exception {
                CreateGroupResult result = null;
                try {
                    result = AWSXRayAsyncClient.this.executeCreateGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSamplingRuleResult> createSamplingRuleAsync(CreateSamplingRuleRequest request) {
        return this.createSamplingRuleAsync(request, null);
    }

    @Override
    public Future<CreateSamplingRuleResult> createSamplingRuleAsync(CreateSamplingRuleRequest request, final AsyncHandler<CreateSamplingRuleRequest, CreateSamplingRuleResult> asyncHandler) {
        final CreateSamplingRuleRequest finalRequest = (CreateSamplingRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSamplingRuleResult>(){

            @Override
            public CreateSamplingRuleResult call() throws Exception {
                CreateSamplingRuleResult result = null;
                try {
                    result = AWSXRayAsyncClient.this.executeCreateSamplingRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteGroupResult> deleteGroupAsync(DeleteGroupRequest request) {
        return this.deleteGroupAsync(request, null);
    }

    @Override
    public Future<DeleteGroupResult> deleteGroupAsync(DeleteGroupRequest request, final AsyncHandler<DeleteGroupRequest, DeleteGroupResult> asyncHandler) {
        final DeleteGroupRequest finalRequest = (DeleteGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteGroupResult>(){

            @Override
            public DeleteGroupResult call() throws Exception {
                DeleteGroupResult result = null;
                try {
                    result = AWSXRayAsyncClient.this.executeDeleteGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSamplingRuleResult> deleteSamplingRuleAsync(DeleteSamplingRuleRequest request) {
        return this.deleteSamplingRuleAsync(request, null);
    }

    @Override
    public Future<DeleteSamplingRuleResult> deleteSamplingRuleAsync(DeleteSamplingRuleRequest request, final AsyncHandler<DeleteSamplingRuleRequest, DeleteSamplingRuleResult> asyncHandler) {
        final DeleteSamplingRuleRequest finalRequest = (DeleteSamplingRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSamplingRuleResult>(){

            @Override
            public DeleteSamplingRuleResult call() throws Exception {
                DeleteSamplingRuleResult result = null;
                try {
                    result = AWSXRayAsyncClient.this.executeDeleteSamplingRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEncryptionConfigResult> getEncryptionConfigAsync(GetEncryptionConfigRequest request) {
        return this.getEncryptionConfigAsync(request, null);
    }

    @Override
    public Future<GetEncryptionConfigResult> getEncryptionConfigAsync(GetEncryptionConfigRequest request, final AsyncHandler<GetEncryptionConfigRequest, GetEncryptionConfigResult> asyncHandler) {
        final GetEncryptionConfigRequest finalRequest = (GetEncryptionConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEncryptionConfigResult>(){

            @Override
            public GetEncryptionConfigResult call() throws Exception {
                GetEncryptionConfigResult result = null;
                try {
                    result = AWSXRayAsyncClient.this.executeGetEncryptionConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetGroupResult> getGroupAsync(GetGroupRequest request) {
        return this.getGroupAsync(request, null);
    }

    @Override
    public Future<GetGroupResult> getGroupAsync(GetGroupRequest request, final AsyncHandler<GetGroupRequest, GetGroupResult> asyncHandler) {
        final GetGroupRequest finalRequest = (GetGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetGroupResult>(){

            @Override
            public GetGroupResult call() throws Exception {
                GetGroupResult result = null;
                try {
                    result = AWSXRayAsyncClient.this.executeGetGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetGroupsResult> getGroupsAsync(GetGroupsRequest request) {
        return this.getGroupsAsync(request, null);
    }

    @Override
    public Future<GetGroupsResult> getGroupsAsync(GetGroupsRequest request, final AsyncHandler<GetGroupsRequest, GetGroupsResult> asyncHandler) {
        final GetGroupsRequest finalRequest = (GetGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetGroupsResult>(){

            @Override
            public GetGroupsResult call() throws Exception {
                GetGroupsResult result = null;
                try {
                    result = AWSXRayAsyncClient.this.executeGetGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSamplingRulesResult> getSamplingRulesAsync(GetSamplingRulesRequest request) {
        return this.getSamplingRulesAsync(request, null);
    }

    @Override
    public Future<GetSamplingRulesResult> getSamplingRulesAsync(GetSamplingRulesRequest request, final AsyncHandler<GetSamplingRulesRequest, GetSamplingRulesResult> asyncHandler) {
        final GetSamplingRulesRequest finalRequest = (GetSamplingRulesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSamplingRulesResult>(){

            @Override
            public GetSamplingRulesResult call() throws Exception {
                GetSamplingRulesResult result = null;
                try {
                    result = AWSXRayAsyncClient.this.executeGetSamplingRules(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSamplingStatisticSummariesResult> getSamplingStatisticSummariesAsync(GetSamplingStatisticSummariesRequest request) {
        return this.getSamplingStatisticSummariesAsync(request, null);
    }

    @Override
    public Future<GetSamplingStatisticSummariesResult> getSamplingStatisticSummariesAsync(GetSamplingStatisticSummariesRequest request, final AsyncHandler<GetSamplingStatisticSummariesRequest, GetSamplingStatisticSummariesResult> asyncHandler) {
        final GetSamplingStatisticSummariesRequest finalRequest = (GetSamplingStatisticSummariesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSamplingStatisticSummariesResult>(){

            @Override
            public GetSamplingStatisticSummariesResult call() throws Exception {
                GetSamplingStatisticSummariesResult result = null;
                try {
                    result = AWSXRayAsyncClient.this.executeGetSamplingStatisticSummaries(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSamplingTargetsResult> getSamplingTargetsAsync(GetSamplingTargetsRequest request) {
        return this.getSamplingTargetsAsync(request, null);
    }

    @Override
    public Future<GetSamplingTargetsResult> getSamplingTargetsAsync(GetSamplingTargetsRequest request, final AsyncHandler<GetSamplingTargetsRequest, GetSamplingTargetsResult> asyncHandler) {
        final GetSamplingTargetsRequest finalRequest = (GetSamplingTargetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSamplingTargetsResult>(){

            @Override
            public GetSamplingTargetsResult call() throws Exception {
                GetSamplingTargetsResult result = null;
                try {
                    result = AWSXRayAsyncClient.this.executeGetSamplingTargets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetServiceGraphResult> getServiceGraphAsync(GetServiceGraphRequest request) {
        return this.getServiceGraphAsync(request, null);
    }

    @Override
    public Future<GetServiceGraphResult> getServiceGraphAsync(GetServiceGraphRequest request, final AsyncHandler<GetServiceGraphRequest, GetServiceGraphResult> asyncHandler) {
        final GetServiceGraphRequest finalRequest = (GetServiceGraphRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetServiceGraphResult>(){

            @Override
            public GetServiceGraphResult call() throws Exception {
                GetServiceGraphResult result = null;
                try {
                    result = AWSXRayAsyncClient.this.executeGetServiceGraph(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTraceGraphResult> getTraceGraphAsync(GetTraceGraphRequest request) {
        return this.getTraceGraphAsync(request, null);
    }

    @Override
    public Future<GetTraceGraphResult> getTraceGraphAsync(GetTraceGraphRequest request, final AsyncHandler<GetTraceGraphRequest, GetTraceGraphResult> asyncHandler) {
        final GetTraceGraphRequest finalRequest = (GetTraceGraphRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTraceGraphResult>(){

            @Override
            public GetTraceGraphResult call() throws Exception {
                GetTraceGraphResult result = null;
                try {
                    result = AWSXRayAsyncClient.this.executeGetTraceGraph(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTraceSummariesResult> getTraceSummariesAsync(GetTraceSummariesRequest request) {
        return this.getTraceSummariesAsync(request, null);
    }

    @Override
    public Future<GetTraceSummariesResult> getTraceSummariesAsync(GetTraceSummariesRequest request, final AsyncHandler<GetTraceSummariesRequest, GetTraceSummariesResult> asyncHandler) {
        final GetTraceSummariesRequest finalRequest = (GetTraceSummariesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTraceSummariesResult>(){

            @Override
            public GetTraceSummariesResult call() throws Exception {
                GetTraceSummariesResult result = null;
                try {
                    result = AWSXRayAsyncClient.this.executeGetTraceSummaries(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutEncryptionConfigResult> putEncryptionConfigAsync(PutEncryptionConfigRequest request) {
        return this.putEncryptionConfigAsync(request, null);
    }

    @Override
    public Future<PutEncryptionConfigResult> putEncryptionConfigAsync(PutEncryptionConfigRequest request, final AsyncHandler<PutEncryptionConfigRequest, PutEncryptionConfigResult> asyncHandler) {
        final PutEncryptionConfigRequest finalRequest = (PutEncryptionConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutEncryptionConfigResult>(){

            @Override
            public PutEncryptionConfigResult call() throws Exception {
                PutEncryptionConfigResult result = null;
                try {
                    result = AWSXRayAsyncClient.this.executePutEncryptionConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutTelemetryRecordsResult> putTelemetryRecordsAsync(PutTelemetryRecordsRequest request) {
        return this.putTelemetryRecordsAsync(request, null);
    }

    @Override
    public Future<PutTelemetryRecordsResult> putTelemetryRecordsAsync(PutTelemetryRecordsRequest request, final AsyncHandler<PutTelemetryRecordsRequest, PutTelemetryRecordsResult> asyncHandler) {
        final PutTelemetryRecordsRequest finalRequest = (PutTelemetryRecordsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutTelemetryRecordsResult>(){

            @Override
            public PutTelemetryRecordsResult call() throws Exception {
                PutTelemetryRecordsResult result = null;
                try {
                    result = AWSXRayAsyncClient.this.executePutTelemetryRecords(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutTraceSegmentsResult> putTraceSegmentsAsync(PutTraceSegmentsRequest request) {
        return this.putTraceSegmentsAsync(request, null);
    }

    @Override
    public Future<PutTraceSegmentsResult> putTraceSegmentsAsync(PutTraceSegmentsRequest request, final AsyncHandler<PutTraceSegmentsRequest, PutTraceSegmentsResult> asyncHandler) {
        final PutTraceSegmentsRequest finalRequest = (PutTraceSegmentsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutTraceSegmentsResult>(){

            @Override
            public PutTraceSegmentsResult call() throws Exception {
                PutTraceSegmentsResult result = null;
                try {
                    result = AWSXRayAsyncClient.this.executePutTraceSegments(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateGroupResult> updateGroupAsync(UpdateGroupRequest request) {
        return this.updateGroupAsync(request, null);
    }

    @Override
    public Future<UpdateGroupResult> updateGroupAsync(UpdateGroupRequest request, final AsyncHandler<UpdateGroupRequest, UpdateGroupResult> asyncHandler) {
        final UpdateGroupRequest finalRequest = (UpdateGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateGroupResult>(){

            @Override
            public UpdateGroupResult call() throws Exception {
                UpdateGroupResult result = null;
                try {
                    result = AWSXRayAsyncClient.this.executeUpdateGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSamplingRuleResult> updateSamplingRuleAsync(UpdateSamplingRuleRequest request) {
        return this.updateSamplingRuleAsync(request, null);
    }

    @Override
    public Future<UpdateSamplingRuleResult> updateSamplingRuleAsync(UpdateSamplingRuleRequest request, final AsyncHandler<UpdateSamplingRuleRequest, UpdateSamplingRuleResult> asyncHandler) {
        final UpdateSamplingRuleRequest finalRequest = (UpdateSamplingRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateSamplingRuleResult>(){

            @Override
            public UpdateSamplingRuleResult call() throws Exception {
                UpdateSamplingRuleResult result = null;
                try {
                    result = AWSXRayAsyncClient.this.executeUpdateSamplingRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

