/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.xray.model.AnnotationValue;
import com.amazonaws.services.xray.model.ServiceId;
import com.amazonaws.services.xray.model.transform.ValueWithServiceIdsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ValueWithServiceIds
implements Serializable,
Cloneable,
StructuredPojo {
    private AnnotationValue annotationValue;
    private List<ServiceId> serviceIds;

    public void setAnnotationValue(AnnotationValue annotationValue) {
        this.annotationValue = annotationValue;
    }

    public AnnotationValue getAnnotationValue() {
        return this.annotationValue;
    }

    public ValueWithServiceIds withAnnotationValue(AnnotationValue annotationValue) {
        this.setAnnotationValue(annotationValue);
        return this;
    }

    public List<ServiceId> getServiceIds() {
        return this.serviceIds;
    }

    public void setServiceIds(Collection<ServiceId> serviceIds) {
        if (serviceIds == null) {
            this.serviceIds = null;
            return;
        }
        this.serviceIds = new ArrayList<ServiceId>(serviceIds);
    }

    public ValueWithServiceIds withServiceIds(ServiceId ... serviceIds) {
        if (this.serviceIds == null) {
            this.setServiceIds(new ArrayList<ServiceId>(serviceIds.length));
        }
        for (ServiceId ele : serviceIds) {
            this.serviceIds.add(ele);
        }
        return this;
    }

    public ValueWithServiceIds withServiceIds(Collection<ServiceId> serviceIds) {
        this.setServiceIds(serviceIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAnnotationValue() != null) {
            sb.append("AnnotationValue: ").append(this.getAnnotationValue()).append(",");
        }
        if (this.getServiceIds() != null) {
            sb.append("ServiceIds: ").append(this.getServiceIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValueWithServiceIds)) {
            return false;
        }
        ValueWithServiceIds other = (ValueWithServiceIds)obj;
        if (other.getAnnotationValue() == null ^ this.getAnnotationValue() == null) {
            return false;
        }
        if (other.getAnnotationValue() != null && !other.getAnnotationValue().equals(this.getAnnotationValue())) {
            return false;
        }
        if (other.getServiceIds() == null ^ this.getServiceIds() == null) {
            return false;
        }
        return other.getServiceIds() == null || other.getServiceIds().equals(this.getServiceIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAnnotationValue() == null ? 0 : this.getAnnotationValue().hashCode());
        hashCode = 31 * hashCode + (this.getServiceIds() == null ? 0 : this.getServiceIds().hashCode());
        return hashCode;
    }

    public ValueWithServiceIds clone() {
        try {
            return (ValueWithServiceIds)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ValueWithServiceIdsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

