/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspacesweb.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.workspacesweb.model.AuthenticationType;
import com.amazonaws.services.workspacesweb.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreatePortalRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Map<String, String> additionalEncryptionContext;
    private String authenticationType;
    private String clientToken;
    private String customerManagedKey;
    private String displayName;
    private List<Tag> tags;

    public Map<String, String> getAdditionalEncryptionContext() {
        return this.additionalEncryptionContext;
    }

    public void setAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
        this.additionalEncryptionContext = additionalEncryptionContext;
    }

    public CreatePortalRequest withAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
        this.setAdditionalEncryptionContext(additionalEncryptionContext);
        return this;
    }

    public CreatePortalRequest addAdditionalEncryptionContextEntry(String key, String value) {
        if (null == this.additionalEncryptionContext) {
            this.additionalEncryptionContext = new HashMap<String, String>();
        }
        if (this.additionalEncryptionContext.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.additionalEncryptionContext.put(key, value);
        return this;
    }

    public CreatePortalRequest clearAdditionalEncryptionContextEntries() {
        this.additionalEncryptionContext = null;
        return this;
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public CreatePortalRequest withAuthenticationType(String authenticationType) {
        this.setAuthenticationType(authenticationType);
        return this;
    }

    public CreatePortalRequest withAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType.toString();
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreatePortalRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setCustomerManagedKey(String customerManagedKey) {
        this.customerManagedKey = customerManagedKey;
    }

    public String getCustomerManagedKey() {
        return this.customerManagedKey;
    }

    public CreatePortalRequest withCustomerManagedKey(String customerManagedKey) {
        this.setCustomerManagedKey(customerManagedKey);
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public CreatePortalRequest withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreatePortalRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreatePortalRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAdditionalEncryptionContext() != null) {
            sb.append("AdditionalEncryptionContext: ").append(this.getAdditionalEncryptionContext()).append(",");
        }
        if (this.getAuthenticationType() != null) {
            sb.append("AuthenticationType: ").append(this.getAuthenticationType()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getCustomerManagedKey() != null) {
            sb.append("CustomerManagedKey: ").append(this.getCustomerManagedKey()).append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePortalRequest)) {
            return false;
        }
        CreatePortalRequest other = (CreatePortalRequest)obj;
        if (other.getAdditionalEncryptionContext() == null ^ this.getAdditionalEncryptionContext() == null) {
            return false;
        }
        if (other.getAdditionalEncryptionContext() != null && !other.getAdditionalEncryptionContext().equals(this.getAdditionalEncryptionContext())) {
            return false;
        }
        if (other.getAuthenticationType() == null ^ this.getAuthenticationType() == null) {
            return false;
        }
        if (other.getAuthenticationType() != null && !other.getAuthenticationType().equals(this.getAuthenticationType())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getCustomerManagedKey() == null ^ this.getCustomerManagedKey() == null) {
            return false;
        }
        if (other.getCustomerManagedKey() != null && !other.getCustomerManagedKey().equals(this.getCustomerManagedKey())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAdditionalEncryptionContext() == null ? 0 : this.getAdditionalEncryptionContext().hashCode());
        hashCode = 31 * hashCode + (this.getAuthenticationType() == null ? 0 : this.getAuthenticationType().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getCustomerManagedKey() == null ? 0 : this.getCustomerManagedKey().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreatePortalRequest clone() {
        return (CreatePortalRequest)super.clone();
    }
}

