/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspacesthinclient.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.workspacesthinclient.model.SoftwareSet;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class SoftwareSetMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").build();
    private static final MarshallingInfo<Date> RELEASEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("releasedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> SUPPORTEDUNTIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportedUntil").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> VALIDATIONSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("validationStatus").build();
    private static final MarshallingInfo<List> SOFTWARE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("software").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final SoftwareSetMarshaller instance = new SoftwareSetMarshaller();

    public static SoftwareSetMarshaller getInstance() {
        return instance;
    }

    public void marshall(SoftwareSet softwareSet, ProtocolMarshaller protocolMarshaller) {
        if (softwareSet == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)softwareSet.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)softwareSet.getVersion(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)softwareSet.getReleasedAt(), RELEASEDAT_BINDING);
            protocolMarshaller.marshall((Object)softwareSet.getSupportedUntil(), SUPPORTEDUNTIL_BINDING);
            protocolMarshaller.marshall((Object)softwareSet.getValidationStatus(), VALIDATIONSTATUS_BINDING);
            protocolMarshaller.marshall(softwareSet.getSoftware(), SOFTWARE_BINDING);
            protocolMarshaller.marshall((Object)softwareSet.getArn(), ARN_BINDING);
            protocolMarshaller.marshall(softwareSet.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

