/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.workspaces.model.WorkspaceDirectory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeWorkspaceDirectoriesResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<WorkspaceDirectory> directories;
    private String nextToken;

    public List<WorkspaceDirectory> getDirectories() {
        if (this.directories == null) {
            this.directories = new ListWithAutoConstructFlag();
            this.directories.setAutoConstruct(true);
        }
        return this.directories;
    }

    public void setDirectories(Collection<WorkspaceDirectory> directories) {
        if (directories == null) {
            this.directories = null;
            return;
        }
        ListWithAutoConstructFlag directoriesCopy = new ListWithAutoConstructFlag(directories.size());
        directoriesCopy.addAll(directories);
        this.directories = directoriesCopy;
    }

    public DescribeWorkspaceDirectoriesResult withDirectories(WorkspaceDirectory ... directories) {
        if (this.getDirectories() == null) {
            this.setDirectories(new ArrayList<WorkspaceDirectory>(directories.length));
        }
        for (WorkspaceDirectory value : directories) {
            this.getDirectories().add(value);
        }
        return this;
    }

    public DescribeWorkspaceDirectoriesResult withDirectories(Collection<WorkspaceDirectory> directories) {
        if (directories == null) {
            this.directories = null;
        } else {
            ListWithAutoConstructFlag directoriesCopy = new ListWithAutoConstructFlag(directories.size());
            directoriesCopy.addAll(directories);
            this.directories = directoriesCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public DescribeWorkspaceDirectoriesResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDirectories() != null) {
            sb.append("Directories: " + this.getDirectories() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDirectories() == null ? 0 : this.getDirectories().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspaceDirectoriesResult)) {
            return false;
        }
        DescribeWorkspaceDirectoriesResult other = (DescribeWorkspaceDirectoriesResult)obj;
        if (other.getDirectories() == null ^ this.getDirectories() == null) {
            return false;
        }
        if (other.getDirectories() != null && !other.getDirectories().equals(this.getDirectories())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public DescribeWorkspaceDirectoriesResult clone() {
        try {
            return (DescribeWorkspaceDirectoriesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

