/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.workspaces.model.DeletableSamlProperty;
import com.amazonaws.services.workspaces.model.SamlProperties;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ModifySamlPropertiesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String resourceId;
    private SamlProperties samlProperties;
    private SdkInternalList<String> propertiesToDelete;

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public ModifySamlPropertiesRequest withResourceId(String resourceId) {
        this.setResourceId(resourceId);
        return this;
    }

    public void setSamlProperties(SamlProperties samlProperties) {
        this.samlProperties = samlProperties;
    }

    public SamlProperties getSamlProperties() {
        return this.samlProperties;
    }

    public ModifySamlPropertiesRequest withSamlProperties(SamlProperties samlProperties) {
        this.setSamlProperties(samlProperties);
        return this;
    }

    public List<String> getPropertiesToDelete() {
        if (this.propertiesToDelete == null) {
            this.propertiesToDelete = new SdkInternalList();
        }
        return this.propertiesToDelete;
    }

    public void setPropertiesToDelete(Collection<String> propertiesToDelete) {
        if (propertiesToDelete == null) {
            this.propertiesToDelete = null;
            return;
        }
        this.propertiesToDelete = new SdkInternalList(propertiesToDelete);
    }

    public ModifySamlPropertiesRequest withPropertiesToDelete(String ... propertiesToDelete) {
        if (this.propertiesToDelete == null) {
            this.setPropertiesToDelete((Collection<String>)new SdkInternalList(propertiesToDelete.length));
        }
        for (String ele : propertiesToDelete) {
            this.propertiesToDelete.add((Object)ele);
        }
        return this;
    }

    public ModifySamlPropertiesRequest withPropertiesToDelete(Collection<String> propertiesToDelete) {
        this.setPropertiesToDelete(propertiesToDelete);
        return this;
    }

    public ModifySamlPropertiesRequest withPropertiesToDelete(DeletableSamlProperty ... propertiesToDelete) {
        SdkInternalList propertiesToDeleteCopy = new SdkInternalList(propertiesToDelete.length);
        for (DeletableSamlProperty value : propertiesToDelete) {
            propertiesToDeleteCopy.add((Object)value.toString());
        }
        if (this.getPropertiesToDelete() == null) {
            this.setPropertiesToDelete((Collection<String>)propertiesToDeleteCopy);
        } else {
            this.getPropertiesToDelete().addAll((Collection<String>)propertiesToDeleteCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceId() != null) {
            sb.append("ResourceId: ").append(this.getResourceId()).append(",");
        }
        if (this.getSamlProperties() != null) {
            sb.append("SamlProperties: ").append(this.getSamlProperties()).append(",");
        }
        if (this.getPropertiesToDelete() != null) {
            sb.append("PropertiesToDelete: ").append(this.getPropertiesToDelete());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySamlPropertiesRequest)) {
            return false;
        }
        ModifySamlPropertiesRequest other = (ModifySamlPropertiesRequest)obj;
        if (other.getResourceId() == null ^ this.getResourceId() == null) {
            return false;
        }
        if (other.getResourceId() != null && !other.getResourceId().equals(this.getResourceId())) {
            return false;
        }
        if (other.getSamlProperties() == null ^ this.getSamlProperties() == null) {
            return false;
        }
        if (other.getSamlProperties() != null && !other.getSamlProperties().equals(this.getSamlProperties())) {
            return false;
        }
        if (other.getPropertiesToDelete() == null ^ this.getPropertiesToDelete() == null) {
            return false;
        }
        return other.getPropertiesToDelete() == null || other.getPropertiesToDelete().equals(this.getPropertiesToDelete());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceId() == null ? 0 : this.getResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getSamlProperties() == null ? 0 : this.getSamlProperties().hashCode());
        hashCode = 31 * hashCode + (this.getPropertiesToDelete() == null ? 0 : this.getPropertiesToDelete().hashCode());
        return hashCode;
    }

    public ModifySamlPropertiesRequest clone() {
        return (ModifySamlPropertiesRequest)super.clone();
    }
}

