/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.workspaces.model.ModifyWorkspacePropertiesRequest;
import com.amazonaws.services.workspaces.model.transform.WorkspacePropertiesJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ModifyWorkspacePropertiesRequestMarshaller
implements Marshaller<Request<ModifyWorkspacePropertiesRequest>, ModifyWorkspacePropertiesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ModifyWorkspacePropertiesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ModifyWorkspacePropertiesRequest> marshall(ModifyWorkspacePropertiesRequest modifyWorkspacePropertiesRequest) {
        if (modifyWorkspacePropertiesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyWorkspacePropertiesRequest, "AmazonWorkspaces");
        request.addHeader("X-Amz-Target", "WorkspacesService.ModifyWorkspaceProperties");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (modifyWorkspacePropertiesRequest.getWorkspaceId() != null) {
                jsonGenerator.writeFieldName("WorkspaceId").writeValue(modifyWorkspacePropertiesRequest.getWorkspaceId());
            }
            if (modifyWorkspacePropertiesRequest.getWorkspaceProperties() != null) {
                jsonGenerator.writeFieldName("WorkspaceProperties");
                WorkspacePropertiesJsonMarshaller.getInstance().marshall(modifyWorkspacePropertiesRequest.getWorkspaceProperties(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

