/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workmailmessageflow.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.workmailmessageflow.model.RawMessageContent;

@SdkInternalApi
public class RawMessageContentMarshaller {
    private static final MarshallingInfo<StructuredPojo> S3REFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Reference").build();
    private static final RawMessageContentMarshaller instance = new RawMessageContentMarshaller();

    public static RawMessageContentMarshaller getInstance() {
        return instance;
    }

    public void marshall(RawMessageContent rawMessageContent, ProtocolMarshaller protocolMarshaller) {
        if (rawMessageContent == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)rawMessageContent.getS3Reference(), S3REFERENCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

