/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.workmail.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.workmail.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * AccessControlRuleMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class AccessControlRuleMarshaller {

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Name").build();
    private static final MarshallingInfo<String> EFFECT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Effect").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<List> IPRANGES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("IpRanges").build();
    private static final MarshallingInfo<List> NOTIPRANGES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("NotIpRanges").build();
    private static final MarshallingInfo<List> ACTIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Actions").build();
    private static final MarshallingInfo<List> NOTACTIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("NotActions").build();
    private static final MarshallingInfo<List> USERIDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("UserIds").build();
    private static final MarshallingInfo<List> NOTUSERIDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("NotUserIds").build();
    private static final MarshallingInfo<java.util.Date> DATECREATED_BINDING = MarshallingInfo.builder(MarshallingType.DATE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DateCreated").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<java.util.Date> DATEMODIFIED_BINDING = MarshallingInfo.builder(MarshallingType.DATE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DateModified").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<List> IMPERSONATIONROLEIDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImpersonationRoleIds").build();
    private static final MarshallingInfo<List> NOTIMPERSONATIONROLEIDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotImpersonationRoleIds").build();

    private static final AccessControlRuleMarshaller instance = new AccessControlRuleMarshaller();

    public static AccessControlRuleMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(AccessControlRule accessControlRule, ProtocolMarshaller protocolMarshaller) {

        if (accessControlRule == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(accessControlRule.getName(), NAME_BINDING);
            protocolMarshaller.marshall(accessControlRule.getEffect(), EFFECT_BINDING);
            protocolMarshaller.marshall(accessControlRule.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(accessControlRule.getIpRanges(), IPRANGES_BINDING);
            protocolMarshaller.marshall(accessControlRule.getNotIpRanges(), NOTIPRANGES_BINDING);
            protocolMarshaller.marshall(accessControlRule.getActions(), ACTIONS_BINDING);
            protocolMarshaller.marshall(accessControlRule.getNotActions(), NOTACTIONS_BINDING);
            protocolMarshaller.marshall(accessControlRule.getUserIds(), USERIDS_BINDING);
            protocolMarshaller.marshall(accessControlRule.getNotUserIds(), NOTUSERIDS_BINDING);
            protocolMarshaller.marshall(accessControlRule.getDateCreated(), DATECREATED_BINDING);
            protocolMarshaller.marshall(accessControlRule.getDateModified(), DATEMODIFIED_BINDING);
            protocolMarshaller.marshall(accessControlRule.getImpersonationRoleIds(), IMPERSONATIONROLEIDS_BINDING);
            protocolMarshaller.marshall(accessControlRule.getNotImpersonationRoleIds(), NOTIMPERSONATIONROLEIDS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
