/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wellarchitected.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wellarchitected.model.JiraSelectedQuestionConfiguration;
import com.amazonaws.services.wellarchitected.model.LensStatus;
import com.amazonaws.services.wellarchitected.model.PillarReviewSummary;
import com.amazonaws.services.wellarchitected.model.WorkloadProfile;
import com.amazonaws.services.wellarchitected.model.transform.LensReviewMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LensReview
implements Serializable,
Cloneable,
StructuredPojo {
    private String lensAlias;
    private String lensArn;
    private String lensVersion;
    private String lensName;
    private String lensStatus;
    private List<PillarReviewSummary> pillarReviewSummaries;
    private JiraSelectedQuestionConfiguration jiraConfiguration;
    private Date updatedAt;
    private String notes;
    private Map<String, Integer> riskCounts;
    private String nextToken;
    private List<WorkloadProfile> profiles;
    private Map<String, Integer> prioritizedRiskCounts;

    public void setLensAlias(String lensAlias) {
        this.lensAlias = lensAlias;
    }

    public String getLensAlias() {
        return this.lensAlias;
    }

    public LensReview withLensAlias(String lensAlias) {
        this.setLensAlias(lensAlias);
        return this;
    }

    public void setLensArn(String lensArn) {
        this.lensArn = lensArn;
    }

    public String getLensArn() {
        return this.lensArn;
    }

    public LensReview withLensArn(String lensArn) {
        this.setLensArn(lensArn);
        return this;
    }

    public void setLensVersion(String lensVersion) {
        this.lensVersion = lensVersion;
    }

    public String getLensVersion() {
        return this.lensVersion;
    }

    public LensReview withLensVersion(String lensVersion) {
        this.setLensVersion(lensVersion);
        return this;
    }

    public void setLensName(String lensName) {
        this.lensName = lensName;
    }

    public String getLensName() {
        return this.lensName;
    }

    public LensReview withLensName(String lensName) {
        this.setLensName(lensName);
        return this;
    }

    public void setLensStatus(String lensStatus) {
        this.lensStatus = lensStatus;
    }

    public String getLensStatus() {
        return this.lensStatus;
    }

    public LensReview withLensStatus(String lensStatus) {
        this.setLensStatus(lensStatus);
        return this;
    }

    public LensReview withLensStatus(LensStatus lensStatus) {
        this.lensStatus = lensStatus.toString();
        return this;
    }

    public List<PillarReviewSummary> getPillarReviewSummaries() {
        return this.pillarReviewSummaries;
    }

    public void setPillarReviewSummaries(Collection<PillarReviewSummary> pillarReviewSummaries) {
        if (pillarReviewSummaries == null) {
            this.pillarReviewSummaries = null;
            return;
        }
        this.pillarReviewSummaries = new ArrayList<PillarReviewSummary>(pillarReviewSummaries);
    }

    public LensReview withPillarReviewSummaries(PillarReviewSummary ... pillarReviewSummaries) {
        if (this.pillarReviewSummaries == null) {
            this.setPillarReviewSummaries(new ArrayList<PillarReviewSummary>(pillarReviewSummaries.length));
        }
        for (PillarReviewSummary ele : pillarReviewSummaries) {
            this.pillarReviewSummaries.add(ele);
        }
        return this;
    }

    public LensReview withPillarReviewSummaries(Collection<PillarReviewSummary> pillarReviewSummaries) {
        this.setPillarReviewSummaries(pillarReviewSummaries);
        return this;
    }

    public void setJiraConfiguration(JiraSelectedQuestionConfiguration jiraConfiguration) {
        this.jiraConfiguration = jiraConfiguration;
    }

    public JiraSelectedQuestionConfiguration getJiraConfiguration() {
        return this.jiraConfiguration;
    }

    public LensReview withJiraConfiguration(JiraSelectedQuestionConfiguration jiraConfiguration) {
        this.setJiraConfiguration(jiraConfiguration);
        return this;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public LensReview withUpdatedAt(Date updatedAt) {
        this.setUpdatedAt(updatedAt);
        return this;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getNotes() {
        return this.notes;
    }

    public LensReview withNotes(String notes) {
        this.setNotes(notes);
        return this;
    }

    public Map<String, Integer> getRiskCounts() {
        return this.riskCounts;
    }

    public void setRiskCounts(Map<String, Integer> riskCounts) {
        this.riskCounts = riskCounts;
    }

    public LensReview withRiskCounts(Map<String, Integer> riskCounts) {
        this.setRiskCounts(riskCounts);
        return this;
    }

    public LensReview addRiskCountsEntry(String key, Integer value) {
        if (null == this.riskCounts) {
            this.riskCounts = new HashMap<String, Integer>();
        }
        if (this.riskCounts.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.riskCounts.put(key, value);
        return this;
    }

    public LensReview clearRiskCountsEntries() {
        this.riskCounts = null;
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public LensReview withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<WorkloadProfile> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(Collection<WorkloadProfile> profiles) {
        if (profiles == null) {
            this.profiles = null;
            return;
        }
        this.profiles = new ArrayList<WorkloadProfile>(profiles);
    }

    public LensReview withProfiles(WorkloadProfile ... profiles) {
        if (this.profiles == null) {
            this.setProfiles(new ArrayList<WorkloadProfile>(profiles.length));
        }
        for (WorkloadProfile ele : profiles) {
            this.profiles.add(ele);
        }
        return this;
    }

    public LensReview withProfiles(Collection<WorkloadProfile> profiles) {
        this.setProfiles(profiles);
        return this;
    }

    public Map<String, Integer> getPrioritizedRiskCounts() {
        return this.prioritizedRiskCounts;
    }

    public void setPrioritizedRiskCounts(Map<String, Integer> prioritizedRiskCounts) {
        this.prioritizedRiskCounts = prioritizedRiskCounts;
    }

    public LensReview withPrioritizedRiskCounts(Map<String, Integer> prioritizedRiskCounts) {
        this.setPrioritizedRiskCounts(prioritizedRiskCounts);
        return this;
    }

    public LensReview addPrioritizedRiskCountsEntry(String key, Integer value) {
        if (null == this.prioritizedRiskCounts) {
            this.prioritizedRiskCounts = new HashMap<String, Integer>();
        }
        if (this.prioritizedRiskCounts.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.prioritizedRiskCounts.put(key, value);
        return this;
    }

    public LensReview clearPrioritizedRiskCountsEntries() {
        this.prioritizedRiskCounts = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLensAlias() != null) {
            sb.append("LensAlias: ").append(this.getLensAlias()).append(",");
        }
        if (this.getLensArn() != null) {
            sb.append("LensArn: ").append(this.getLensArn()).append(",");
        }
        if (this.getLensVersion() != null) {
            sb.append("LensVersion: ").append(this.getLensVersion()).append(",");
        }
        if (this.getLensName() != null) {
            sb.append("LensName: ").append(this.getLensName()).append(",");
        }
        if (this.getLensStatus() != null) {
            sb.append("LensStatus: ").append(this.getLensStatus()).append(",");
        }
        if (this.getPillarReviewSummaries() != null) {
            sb.append("PillarReviewSummaries: ").append(this.getPillarReviewSummaries()).append(",");
        }
        if (this.getJiraConfiguration() != null) {
            sb.append("JiraConfiguration: ").append(this.getJiraConfiguration()).append(",");
        }
        if (this.getUpdatedAt() != null) {
            sb.append("UpdatedAt: ").append(this.getUpdatedAt()).append(",");
        }
        if (this.getNotes() != null) {
            sb.append("Notes: ").append(this.getNotes()).append(",");
        }
        if (this.getRiskCounts() != null) {
            sb.append("RiskCounts: ").append(this.getRiskCounts()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getProfiles() != null) {
            sb.append("Profiles: ").append(this.getProfiles()).append(",");
        }
        if (this.getPrioritizedRiskCounts() != null) {
            sb.append("PrioritizedRiskCounts: ").append(this.getPrioritizedRiskCounts());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LensReview)) {
            return false;
        }
        LensReview other = (LensReview)obj;
        if (other.getLensAlias() == null ^ this.getLensAlias() == null) {
            return false;
        }
        if (other.getLensAlias() != null && !other.getLensAlias().equals(this.getLensAlias())) {
            return false;
        }
        if (other.getLensArn() == null ^ this.getLensArn() == null) {
            return false;
        }
        if (other.getLensArn() != null && !other.getLensArn().equals(this.getLensArn())) {
            return false;
        }
        if (other.getLensVersion() == null ^ this.getLensVersion() == null) {
            return false;
        }
        if (other.getLensVersion() != null && !other.getLensVersion().equals(this.getLensVersion())) {
            return false;
        }
        if (other.getLensName() == null ^ this.getLensName() == null) {
            return false;
        }
        if (other.getLensName() != null && !other.getLensName().equals(this.getLensName())) {
            return false;
        }
        if (other.getLensStatus() == null ^ this.getLensStatus() == null) {
            return false;
        }
        if (other.getLensStatus() != null && !other.getLensStatus().equals(this.getLensStatus())) {
            return false;
        }
        if (other.getPillarReviewSummaries() == null ^ this.getPillarReviewSummaries() == null) {
            return false;
        }
        if (other.getPillarReviewSummaries() != null && !other.getPillarReviewSummaries().equals(this.getPillarReviewSummaries())) {
            return false;
        }
        if (other.getJiraConfiguration() == null ^ this.getJiraConfiguration() == null) {
            return false;
        }
        if (other.getJiraConfiguration() != null && !other.getJiraConfiguration().equals(this.getJiraConfiguration())) {
            return false;
        }
        if (other.getUpdatedAt() == null ^ this.getUpdatedAt() == null) {
            return false;
        }
        if (other.getUpdatedAt() != null && !other.getUpdatedAt().equals(this.getUpdatedAt())) {
            return false;
        }
        if (other.getNotes() == null ^ this.getNotes() == null) {
            return false;
        }
        if (other.getNotes() != null && !other.getNotes().equals(this.getNotes())) {
            return false;
        }
        if (other.getRiskCounts() == null ^ this.getRiskCounts() == null) {
            return false;
        }
        if (other.getRiskCounts() != null && !other.getRiskCounts().equals(this.getRiskCounts())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getProfiles() == null ^ this.getProfiles() == null) {
            return false;
        }
        if (other.getProfiles() != null && !other.getProfiles().equals(this.getProfiles())) {
            return false;
        }
        if (other.getPrioritizedRiskCounts() == null ^ this.getPrioritizedRiskCounts() == null) {
            return false;
        }
        return other.getPrioritizedRiskCounts() == null || other.getPrioritizedRiskCounts().equals(this.getPrioritizedRiskCounts());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLensAlias() == null ? 0 : this.getLensAlias().hashCode());
        hashCode = 31 * hashCode + (this.getLensArn() == null ? 0 : this.getLensArn().hashCode());
        hashCode = 31 * hashCode + (this.getLensVersion() == null ? 0 : this.getLensVersion().hashCode());
        hashCode = 31 * hashCode + (this.getLensName() == null ? 0 : this.getLensName().hashCode());
        hashCode = 31 * hashCode + (this.getLensStatus() == null ? 0 : this.getLensStatus().hashCode());
        hashCode = 31 * hashCode + (this.getPillarReviewSummaries() == null ? 0 : this.getPillarReviewSummaries().hashCode());
        hashCode = 31 * hashCode + (this.getJiraConfiguration() == null ? 0 : this.getJiraConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getUpdatedAt() == null ? 0 : this.getUpdatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getNotes() == null ? 0 : this.getNotes().hashCode());
        hashCode = 31 * hashCode + (this.getRiskCounts() == null ? 0 : this.getRiskCounts().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getProfiles() == null ? 0 : this.getProfiles().hashCode());
        hashCode = 31 * hashCode + (this.getPrioritizedRiskCounts() == null ? 0 : this.getPrioritizedRiskCounts().hashCode());
        return hashCode;
    }

    public LensReview clone() {
        try {
            return (LensReview)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LensReviewMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

