/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.wafv2.model.Rule;
import com.amazonaws.services.wafv2.model.Scope;
import com.amazonaws.services.wafv2.model.VisibilityConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateRuleGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String scope;
    private String id;
    private String description;
    private List<Rule> rules;
    private VisibilityConfig visibilityConfig;
    private String lockToken;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public UpdateRuleGroupRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public UpdateRuleGroupRequest withScope(String scope) {
        this.setScope(scope);
        return this;
    }

    public UpdateRuleGroupRequest withScope(Scope scope) {
        this.scope = scope.toString();
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public UpdateRuleGroupRequest withId(String id) {
        this.setId(id);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateRuleGroupRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(Collection<Rule> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        this.rules = new ArrayList<Rule>(rules);
    }

    public UpdateRuleGroupRequest withRules(Rule ... rules) {
        if (this.rules == null) {
            this.setRules(new ArrayList<Rule>(rules.length));
        }
        for (Rule ele : rules) {
            this.rules.add(ele);
        }
        return this;
    }

    public UpdateRuleGroupRequest withRules(Collection<Rule> rules) {
        this.setRules(rules);
        return this;
    }

    public void setVisibilityConfig(VisibilityConfig visibilityConfig) {
        this.visibilityConfig = visibilityConfig;
    }

    public VisibilityConfig getVisibilityConfig() {
        return this.visibilityConfig;
    }

    public UpdateRuleGroupRequest withVisibilityConfig(VisibilityConfig visibilityConfig) {
        this.setVisibilityConfig(visibilityConfig);
        return this;
    }

    public void setLockToken(String lockToken) {
        this.lockToken = lockToken;
    }

    public String getLockToken() {
        return this.lockToken;
    }

    public UpdateRuleGroupRequest withLockToken(String lockToken) {
        this.setLockToken(lockToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getScope() != null) {
            sb.append("Scope: ").append(this.getScope()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getRules() != null) {
            sb.append("Rules: ").append(this.getRules()).append(",");
        }
        if (this.getVisibilityConfig() != null) {
            sb.append("VisibilityConfig: ").append(this.getVisibilityConfig()).append(",");
        }
        if (this.getLockToken() != null) {
            sb.append("LockToken: ").append(this.getLockToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRuleGroupRequest)) {
            return false;
        }
        UpdateRuleGroupRequest other = (UpdateRuleGroupRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getScope() == null ^ this.getScope() == null) {
            return false;
        }
        if (other.getScope() != null && !other.getScope().equals(this.getScope())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        if (other.getRules() != null && !other.getRules().equals(this.getRules())) {
            return false;
        }
        if (other.getVisibilityConfig() == null ^ this.getVisibilityConfig() == null) {
            return false;
        }
        if (other.getVisibilityConfig() != null && !other.getVisibilityConfig().equals(this.getVisibilityConfig())) {
            return false;
        }
        if (other.getLockToken() == null ^ this.getLockToken() == null) {
            return false;
        }
        return other.getLockToken() == null || other.getLockToken().equals(this.getLockToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getScope() == null ? 0 : this.getScope().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        hashCode = 31 * hashCode + (this.getVisibilityConfig() == null ? 0 : this.getVisibilityConfig().hashCode());
        hashCode = 31 * hashCode + (this.getLockToken() == null ? 0 : this.getLockToken().hashCode());
        return hashCode;
    }

    public UpdateRuleGroupRequest clone() {
        return (UpdateRuleGroupRequest)super.clone();
    }
}

