/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.waf.model.Predicate;
import com.amazonaws.services.waf.model.RateKey;
import com.amazonaws.services.waf.model.waf_regional.transform.RateBasedRuleMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RateBasedRule
implements Serializable,
Cloneable,
StructuredPojo {
    private String ruleId;
    private String name;
    private String metricName;
    private List<Predicate> matchPredicates;
    private String rateKey;
    private Long rateLimit;

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public RateBasedRule withRuleId(String ruleId) {
        this.setRuleId(ruleId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public RateBasedRule withName(String name) {
        this.setName(name);
        return this;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public RateBasedRule withMetricName(String metricName) {
        this.setMetricName(metricName);
        return this;
    }

    public List<Predicate> getMatchPredicates() {
        return this.matchPredicates;
    }

    public void setMatchPredicates(Collection<Predicate> matchPredicates) {
        if (matchPredicates == null) {
            this.matchPredicates = null;
            return;
        }
        this.matchPredicates = new ArrayList<Predicate>(matchPredicates);
    }

    public RateBasedRule withMatchPredicates(Predicate ... matchPredicates) {
        if (this.matchPredicates == null) {
            this.setMatchPredicates(new ArrayList<Predicate>(matchPredicates.length));
        }
        for (Predicate ele : matchPredicates) {
            this.matchPredicates.add(ele);
        }
        return this;
    }

    public RateBasedRule withMatchPredicates(Collection<Predicate> matchPredicates) {
        this.setMatchPredicates(matchPredicates);
        return this;
    }

    public void setRateKey(String rateKey) {
        this.rateKey = rateKey;
    }

    @JsonProperty(value="rateKey")
    public String getRateKey() {
        return this.rateKey;
    }

    public RateBasedRule withRateKey(String rateKey) {
        this.setRateKey(rateKey);
        return this;
    }

    @JsonIgnore
    public void setRateKey(RateKey rateKey) {
        this.withRateKey(rateKey);
    }

    public RateBasedRule withRateKey(RateKey rateKey) {
        this.rateKey = rateKey.toString();
        return this;
    }

    public void setRateLimit(Long rateLimit) {
        this.rateLimit = rateLimit;
    }

    public Long getRateLimit() {
        return this.rateLimit;
    }

    public RateBasedRule withRateLimit(Long rateLimit) {
        this.setRateLimit(rateLimit);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRuleId() != null) {
            sb.append("RuleId: ").append(this.getRuleId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getMetricName() != null) {
            sb.append("MetricName: ").append(this.getMetricName()).append(",");
        }
        if (this.getMatchPredicates() != null) {
            sb.append("MatchPredicates: ").append(this.getMatchPredicates()).append(",");
        }
        if (this.getRateKey() != null) {
            sb.append("RateKey: ").append(this.getRateKey()).append(",");
        }
        if (this.getRateLimit() != null) {
            sb.append("RateLimit: ").append(this.getRateLimit());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RateBasedRule)) {
            return false;
        }
        RateBasedRule other = (RateBasedRule)obj;
        if (other.getRuleId() == null ^ this.getRuleId() == null) {
            return false;
        }
        if (other.getRuleId() != null && !other.getRuleId().equals(this.getRuleId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        if (other.getMetricName() != null && !other.getMetricName().equals(this.getMetricName())) {
            return false;
        }
        if (other.getMatchPredicates() == null ^ this.getMatchPredicates() == null) {
            return false;
        }
        if (other.getMatchPredicates() != null && !other.getMatchPredicates().equals(this.getMatchPredicates())) {
            return false;
        }
        if (other.getRateKey() == null ^ this.getRateKey() == null) {
            return false;
        }
        if (other.getRateKey() != null && !other.getRateKey().equals(this.getRateKey())) {
            return false;
        }
        if (other.getRateLimit() == null ^ this.getRateLimit() == null) {
            return false;
        }
        return other.getRateLimit() == null || other.getRateLimit().equals(this.getRateLimit());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRuleId() == null ? 0 : this.getRuleId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        hashCode = 31 * hashCode + (this.getMatchPredicates() == null ? 0 : this.getMatchPredicates().hashCode());
        hashCode = 31 * hashCode + (this.getRateKey() == null ? 0 : this.getRateKey().hashCode());
        hashCode = 31 * hashCode + (this.getRateLimit() == null ? 0 : this.getRateLimit().hashCode());
        return hashCode;
    }

    public RateBasedRule clone() {
        try {
            return (RateBasedRule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RateBasedRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

