/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.waf.model.HTTPHeader;
import com.amazonaws.services.waf.model.waf_regional.transform.HTTPRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HTTPRequest
implements Serializable,
Cloneable,
StructuredPojo {
    private String clientIP;
    private String country;
    private String uRI;
    private String method;
    private String hTTPVersion;
    private List<HTTPHeader> headers;

    public void setClientIP(String clientIP) {
        this.clientIP = clientIP;
    }

    public String getClientIP() {
        return this.clientIP;
    }

    public HTTPRequest withClientIP(String clientIP) {
        this.setClientIP(clientIP);
        return this;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCountry() {
        return this.country;
    }

    public HTTPRequest withCountry(String country) {
        this.setCountry(country);
        return this;
    }

    public void setURI(String uRI) {
        this.uRI = uRI;
    }

    public String getURI() {
        return this.uRI;
    }

    public HTTPRequest withURI(String uRI) {
        this.setURI(uRI);
        return this;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public HTTPRequest withMethod(String method) {
        this.setMethod(method);
        return this;
    }

    public void setHTTPVersion(String hTTPVersion) {
        this.hTTPVersion = hTTPVersion;
    }

    public String getHTTPVersion() {
        return this.hTTPVersion;
    }

    public HTTPRequest withHTTPVersion(String hTTPVersion) {
        this.setHTTPVersion(hTTPVersion);
        return this;
    }

    public List<HTTPHeader> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Collection<HTTPHeader> headers) {
        if (headers == null) {
            this.headers = null;
            return;
        }
        this.headers = new ArrayList<HTTPHeader>(headers);
    }

    public HTTPRequest withHeaders(HTTPHeader ... headers) {
        if (this.headers == null) {
            this.setHeaders(new ArrayList<HTTPHeader>(headers.length));
        }
        for (HTTPHeader ele : headers) {
            this.headers.add(ele);
        }
        return this;
    }

    public HTTPRequest withHeaders(Collection<HTTPHeader> headers) {
        this.setHeaders(headers);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientIP() != null) {
            sb.append("ClientIP: ").append(this.getClientIP()).append(",");
        }
        if (this.getCountry() != null) {
            sb.append("Country: ").append(this.getCountry()).append(",");
        }
        if (this.getURI() != null) {
            sb.append("URI: ").append(this.getURI()).append(",");
        }
        if (this.getMethod() != null) {
            sb.append("Method: ").append(this.getMethod()).append(",");
        }
        if (this.getHTTPVersion() != null) {
            sb.append("HTTPVersion: ").append(this.getHTTPVersion()).append(",");
        }
        if (this.getHeaders() != null) {
            sb.append("Headers: ").append(this.getHeaders());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HTTPRequest)) {
            return false;
        }
        HTTPRequest other = (HTTPRequest)obj;
        if (other.getClientIP() == null ^ this.getClientIP() == null) {
            return false;
        }
        if (other.getClientIP() != null && !other.getClientIP().equals(this.getClientIP())) {
            return false;
        }
        if (other.getCountry() == null ^ this.getCountry() == null) {
            return false;
        }
        if (other.getCountry() != null && !other.getCountry().equals(this.getCountry())) {
            return false;
        }
        if (other.getURI() == null ^ this.getURI() == null) {
            return false;
        }
        if (other.getURI() != null && !other.getURI().equals(this.getURI())) {
            return false;
        }
        if (other.getMethod() == null ^ this.getMethod() == null) {
            return false;
        }
        if (other.getMethod() != null && !other.getMethod().equals(this.getMethod())) {
            return false;
        }
        if (other.getHTTPVersion() == null ^ this.getHTTPVersion() == null) {
            return false;
        }
        if (other.getHTTPVersion() != null && !other.getHTTPVersion().equals(this.getHTTPVersion())) {
            return false;
        }
        if (other.getHeaders() == null ^ this.getHeaders() == null) {
            return false;
        }
        return other.getHeaders() == null || other.getHeaders().equals(this.getHeaders());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientIP() == null ? 0 : this.getClientIP().hashCode());
        hashCode = 31 * hashCode + (this.getCountry() == null ? 0 : this.getCountry().hashCode());
        hashCode = 31 * hashCode + (this.getURI() == null ? 0 : this.getURI().hashCode());
        hashCode = 31 * hashCode + (this.getMethod() == null ? 0 : this.getMethod().hashCode());
        hashCode = 31 * hashCode + (this.getHTTPVersion() == null ? 0 : this.getHTTPVersion().hashCode());
        hashCode = 31 * hashCode + (this.getHeaders() == null ? 0 : this.getHeaders().hashCode());
        return hashCode;
    }

    public HTTPRequest clone() {
        try {
            return (HTTPRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HTTPRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

