/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.voiceid.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.voiceid.model.FraudDetectionConfiguration;
import com.amazonaws.services.voiceid.model.FraudDetectionDecision;
import com.amazonaws.services.voiceid.model.FraudDetectionReason;
import com.amazonaws.services.voiceid.model.FraudRiskDetails;
import com.amazonaws.services.voiceid.model.transform.FraudDetectionResultMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class FraudDetectionResult
implements Serializable,
Cloneable,
StructuredPojo {
    private Date audioAggregationEndedAt;
    private Date audioAggregationStartedAt;
    private FraudDetectionConfiguration configuration;
    private String decision;
    private String fraudDetectionResultId;
    private List<String> reasons;
    private FraudRiskDetails riskDetails;

    public void setAudioAggregationEndedAt(Date audioAggregationEndedAt) {
        this.audioAggregationEndedAt = audioAggregationEndedAt;
    }

    public Date getAudioAggregationEndedAt() {
        return this.audioAggregationEndedAt;
    }

    public FraudDetectionResult withAudioAggregationEndedAt(Date audioAggregationEndedAt) {
        this.setAudioAggregationEndedAt(audioAggregationEndedAt);
        return this;
    }

    public void setAudioAggregationStartedAt(Date audioAggregationStartedAt) {
        this.audioAggregationStartedAt = audioAggregationStartedAt;
    }

    public Date getAudioAggregationStartedAt() {
        return this.audioAggregationStartedAt;
    }

    public FraudDetectionResult withAudioAggregationStartedAt(Date audioAggregationStartedAt) {
        this.setAudioAggregationStartedAt(audioAggregationStartedAt);
        return this;
    }

    public void setConfiguration(FraudDetectionConfiguration configuration) {
        this.configuration = configuration;
    }

    public FraudDetectionConfiguration getConfiguration() {
        return this.configuration;
    }

    public FraudDetectionResult withConfiguration(FraudDetectionConfiguration configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public void setDecision(String decision) {
        this.decision = decision;
    }

    public String getDecision() {
        return this.decision;
    }

    public FraudDetectionResult withDecision(String decision) {
        this.setDecision(decision);
        return this;
    }

    public FraudDetectionResult withDecision(FraudDetectionDecision decision) {
        this.decision = decision.toString();
        return this;
    }

    public void setFraudDetectionResultId(String fraudDetectionResultId) {
        this.fraudDetectionResultId = fraudDetectionResultId;
    }

    public String getFraudDetectionResultId() {
        return this.fraudDetectionResultId;
    }

    public FraudDetectionResult withFraudDetectionResultId(String fraudDetectionResultId) {
        this.setFraudDetectionResultId(fraudDetectionResultId);
        return this;
    }

    public List<String> getReasons() {
        return this.reasons;
    }

    public void setReasons(Collection<String> reasons) {
        if (reasons == null) {
            this.reasons = null;
            return;
        }
        this.reasons = new ArrayList<String>(reasons);
    }

    public FraudDetectionResult withReasons(String ... reasons) {
        if (this.reasons == null) {
            this.setReasons(new ArrayList<String>(reasons.length));
        }
        for (String ele : reasons) {
            this.reasons.add(ele);
        }
        return this;
    }

    public FraudDetectionResult withReasons(Collection<String> reasons) {
        this.setReasons(reasons);
        return this;
    }

    public FraudDetectionResult withReasons(FraudDetectionReason ... reasons) {
        ArrayList<String> reasonsCopy = new ArrayList<String>(reasons.length);
        for (FraudDetectionReason value : reasons) {
            reasonsCopy.add(value.toString());
        }
        if (this.getReasons() == null) {
            this.setReasons(reasonsCopy);
        } else {
            this.getReasons().addAll(reasonsCopy);
        }
        return this;
    }

    public void setRiskDetails(FraudRiskDetails riskDetails) {
        this.riskDetails = riskDetails;
    }

    public FraudRiskDetails getRiskDetails() {
        return this.riskDetails;
    }

    public FraudDetectionResult withRiskDetails(FraudRiskDetails riskDetails) {
        this.setRiskDetails(riskDetails);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAudioAggregationEndedAt() != null) {
            sb.append("AudioAggregationEndedAt: ").append(this.getAudioAggregationEndedAt()).append(",");
        }
        if (this.getAudioAggregationStartedAt() != null) {
            sb.append("AudioAggregationStartedAt: ").append(this.getAudioAggregationStartedAt()).append(",");
        }
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration()).append(",");
        }
        if (this.getDecision() != null) {
            sb.append("Decision: ").append(this.getDecision()).append(",");
        }
        if (this.getFraudDetectionResultId() != null) {
            sb.append("FraudDetectionResultId: ").append(this.getFraudDetectionResultId()).append(",");
        }
        if (this.getReasons() != null) {
            sb.append("Reasons: ").append(this.getReasons()).append(",");
        }
        if (this.getRiskDetails() != null) {
            sb.append("RiskDetails: ").append(this.getRiskDetails());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FraudDetectionResult)) {
            return false;
        }
        FraudDetectionResult other = (FraudDetectionResult)obj;
        if (other.getAudioAggregationEndedAt() == null ^ this.getAudioAggregationEndedAt() == null) {
            return false;
        }
        if (other.getAudioAggregationEndedAt() != null && !other.getAudioAggregationEndedAt().equals(this.getAudioAggregationEndedAt())) {
            return false;
        }
        if (other.getAudioAggregationStartedAt() == null ^ this.getAudioAggregationStartedAt() == null) {
            return false;
        }
        if (other.getAudioAggregationStartedAt() != null && !other.getAudioAggregationStartedAt().equals(this.getAudioAggregationStartedAt())) {
            return false;
        }
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        if (other.getConfiguration() != null && !other.getConfiguration().equals(this.getConfiguration())) {
            return false;
        }
        if (other.getDecision() == null ^ this.getDecision() == null) {
            return false;
        }
        if (other.getDecision() != null && !other.getDecision().equals(this.getDecision())) {
            return false;
        }
        if (other.getFraudDetectionResultId() == null ^ this.getFraudDetectionResultId() == null) {
            return false;
        }
        if (other.getFraudDetectionResultId() != null && !other.getFraudDetectionResultId().equals(this.getFraudDetectionResultId())) {
            return false;
        }
        if (other.getReasons() == null ^ this.getReasons() == null) {
            return false;
        }
        if (other.getReasons() != null && !other.getReasons().equals(this.getReasons())) {
            return false;
        }
        if (other.getRiskDetails() == null ^ this.getRiskDetails() == null) {
            return false;
        }
        return other.getRiskDetails() == null || other.getRiskDetails().equals(this.getRiskDetails());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAudioAggregationEndedAt() == null ? 0 : this.getAudioAggregationEndedAt().hashCode());
        hashCode = 31 * hashCode + (this.getAudioAggregationStartedAt() == null ? 0 : this.getAudioAggregationStartedAt().hashCode());
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getDecision() == null ? 0 : this.getDecision().hashCode());
        hashCode = 31 * hashCode + (this.getFraudDetectionResultId() == null ? 0 : this.getFraudDetectionResultId().hashCode());
        hashCode = 31 * hashCode + (this.getReasons() == null ? 0 : this.getReasons().hashCode());
        hashCode = 31 * hashCode + (this.getRiskDetails() == null ? 0 : this.getRiskDetails().hashCode());
        return hashCode;
    }

    public FraudDetectionResult clone() {
        try {
            return (FraudDetectionResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FraudDetectionResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

