/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.verifiedpermissions.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.verifiedpermissions.model.transform.CognitoUserPoolConfigurationItemMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CognitoUserPoolConfigurationItem
implements Serializable,
Cloneable,
StructuredPojo {
    private String userPoolArn;
    private List<String> clientIds;
    private String issuer;

    public void setUserPoolArn(String userPoolArn) {
        this.userPoolArn = userPoolArn;
    }

    public String getUserPoolArn() {
        return this.userPoolArn;
    }

    public CognitoUserPoolConfigurationItem withUserPoolArn(String userPoolArn) {
        this.setUserPoolArn(userPoolArn);
        return this;
    }

    public List<String> getClientIds() {
        return this.clientIds;
    }

    public void setClientIds(Collection<String> clientIds) {
        if (clientIds == null) {
            this.clientIds = null;
            return;
        }
        this.clientIds = new ArrayList<String>(clientIds);
    }

    public CognitoUserPoolConfigurationItem withClientIds(String ... clientIds) {
        if (this.clientIds == null) {
            this.setClientIds(new ArrayList<String>(clientIds.length));
        }
        for (String ele : clientIds) {
            this.clientIds.add(ele);
        }
        return this;
    }

    public CognitoUserPoolConfigurationItem withClientIds(Collection<String> clientIds) {
        this.setClientIds(clientIds);
        return this;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public CognitoUserPoolConfigurationItem withIssuer(String issuer) {
        this.setIssuer(issuer);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserPoolArn() != null) {
            sb.append("UserPoolArn: ").append(this.getUserPoolArn()).append(",");
        }
        if (this.getClientIds() != null) {
            sb.append("ClientIds: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getIssuer() != null) {
            sb.append("Issuer: ").append(this.getIssuer());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CognitoUserPoolConfigurationItem)) {
            return false;
        }
        CognitoUserPoolConfigurationItem other = (CognitoUserPoolConfigurationItem)obj;
        if (other.getUserPoolArn() == null ^ this.getUserPoolArn() == null) {
            return false;
        }
        if (other.getUserPoolArn() != null && !other.getUserPoolArn().equals(this.getUserPoolArn())) {
            return false;
        }
        if (other.getClientIds() == null ^ this.getClientIds() == null) {
            return false;
        }
        if (other.getClientIds() != null && !other.getClientIds().equals(this.getClientIds())) {
            return false;
        }
        if (other.getIssuer() == null ^ this.getIssuer() == null) {
            return false;
        }
        return other.getIssuer() == null || other.getIssuer().equals(this.getIssuer());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserPoolArn() == null ? 0 : this.getUserPoolArn().hashCode());
        hashCode = 31 * hashCode + (this.getClientIds() == null ? 0 : this.getClientIds().hashCode());
        hashCode = 31 * hashCode + (this.getIssuer() == null ? 0 : this.getIssuer().hashCode());
        return hashCode;
    }

    public CognitoUserPoolConfigurationItem clone() {
        try {
            return (CognitoUserPoolConfigurationItem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CognitoUserPoolConfigurationItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

