/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.translate.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.translate.model.Directionality;
import com.amazonaws.services.translate.model.EncryptionKey;
import com.amazonaws.services.translate.model.TerminologyDataFormat;
import com.amazonaws.services.translate.model.transform.TerminologyPropertiesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class TerminologyProperties
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String description;
    private String arn;
    private String sourceLanguageCode;
    private List<String> targetLanguageCodes;
    private EncryptionKey encryptionKey;
    private Integer sizeBytes;
    private Integer termCount;
    private Date createdAt;
    private Date lastUpdatedAt;
    private String directionality;
    private String message;
    private Integer skippedTermCount;
    private String format;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public TerminologyProperties withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public TerminologyProperties withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public TerminologyProperties withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setSourceLanguageCode(String sourceLanguageCode) {
        this.sourceLanguageCode = sourceLanguageCode;
    }

    public String getSourceLanguageCode() {
        return this.sourceLanguageCode;
    }

    public TerminologyProperties withSourceLanguageCode(String sourceLanguageCode) {
        this.setSourceLanguageCode(sourceLanguageCode);
        return this;
    }

    public List<String> getTargetLanguageCodes() {
        return this.targetLanguageCodes;
    }

    public void setTargetLanguageCodes(Collection<String> targetLanguageCodes) {
        if (targetLanguageCodes == null) {
            this.targetLanguageCodes = null;
            return;
        }
        this.targetLanguageCodes = new ArrayList<String>(targetLanguageCodes);
    }

    public TerminologyProperties withTargetLanguageCodes(String ... targetLanguageCodes) {
        if (this.targetLanguageCodes == null) {
            this.setTargetLanguageCodes(new ArrayList<String>(targetLanguageCodes.length));
        }
        for (String ele : targetLanguageCodes) {
            this.targetLanguageCodes.add(ele);
        }
        return this;
    }

    public TerminologyProperties withTargetLanguageCodes(Collection<String> targetLanguageCodes) {
        this.setTargetLanguageCodes(targetLanguageCodes);
        return this;
    }

    public void setEncryptionKey(EncryptionKey encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public EncryptionKey getEncryptionKey() {
        return this.encryptionKey;
    }

    public TerminologyProperties withEncryptionKey(EncryptionKey encryptionKey) {
        this.setEncryptionKey(encryptionKey);
        return this;
    }

    public void setSizeBytes(Integer sizeBytes) {
        this.sizeBytes = sizeBytes;
    }

    public Integer getSizeBytes() {
        return this.sizeBytes;
    }

    public TerminologyProperties withSizeBytes(Integer sizeBytes) {
        this.setSizeBytes(sizeBytes);
        return this;
    }

    public void setTermCount(Integer termCount) {
        this.termCount = termCount;
    }

    public Integer getTermCount() {
        return this.termCount;
    }

    public TerminologyProperties withTermCount(Integer termCount) {
        this.setTermCount(termCount);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public TerminologyProperties withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setLastUpdatedAt(Date lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
    }

    public Date getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public TerminologyProperties withLastUpdatedAt(Date lastUpdatedAt) {
        this.setLastUpdatedAt(lastUpdatedAt);
        return this;
    }

    public void setDirectionality(String directionality) {
        this.directionality = directionality;
    }

    public String getDirectionality() {
        return this.directionality;
    }

    public TerminologyProperties withDirectionality(String directionality) {
        this.setDirectionality(directionality);
        return this;
    }

    public TerminologyProperties withDirectionality(Directionality directionality) {
        this.directionality = directionality.toString();
        return this;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public TerminologyProperties withMessage(String message) {
        this.setMessage(message);
        return this;
    }

    public void setSkippedTermCount(Integer skippedTermCount) {
        this.skippedTermCount = skippedTermCount;
    }

    public Integer getSkippedTermCount() {
        return this.skippedTermCount;
    }

    public TerminologyProperties withSkippedTermCount(Integer skippedTermCount) {
        this.setSkippedTermCount(skippedTermCount);
        return this;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public TerminologyProperties withFormat(String format) {
        this.setFormat(format);
        return this;
    }

    public TerminologyProperties withFormat(TerminologyDataFormat format) {
        this.format = format.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getSourceLanguageCode() != null) {
            sb.append("SourceLanguageCode: ").append(this.getSourceLanguageCode()).append(",");
        }
        if (this.getTargetLanguageCodes() != null) {
            sb.append("TargetLanguageCodes: ").append(this.getTargetLanguageCodes()).append(",");
        }
        if (this.getEncryptionKey() != null) {
            sb.append("EncryptionKey: ").append(this.getEncryptionKey()).append(",");
        }
        if (this.getSizeBytes() != null) {
            sb.append("SizeBytes: ").append(this.getSizeBytes()).append(",");
        }
        if (this.getTermCount() != null) {
            sb.append("TermCount: ").append(this.getTermCount()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getLastUpdatedAt() != null) {
            sb.append("LastUpdatedAt: ").append(this.getLastUpdatedAt()).append(",");
        }
        if (this.getDirectionality() != null) {
            sb.append("Directionality: ").append(this.getDirectionality()).append(",");
        }
        if (this.getMessage() != null) {
            sb.append("Message: ").append(this.getMessage()).append(",");
        }
        if (this.getSkippedTermCount() != null) {
            sb.append("SkippedTermCount: ").append(this.getSkippedTermCount()).append(",");
        }
        if (this.getFormat() != null) {
            sb.append("Format: ").append(this.getFormat());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminologyProperties)) {
            return false;
        }
        TerminologyProperties other = (TerminologyProperties)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getSourceLanguageCode() == null ^ this.getSourceLanguageCode() == null) {
            return false;
        }
        if (other.getSourceLanguageCode() != null && !other.getSourceLanguageCode().equals(this.getSourceLanguageCode())) {
            return false;
        }
        if (other.getTargetLanguageCodes() == null ^ this.getTargetLanguageCodes() == null) {
            return false;
        }
        if (other.getTargetLanguageCodes() != null && !other.getTargetLanguageCodes().equals(this.getTargetLanguageCodes())) {
            return false;
        }
        if (other.getEncryptionKey() == null ^ this.getEncryptionKey() == null) {
            return false;
        }
        if (other.getEncryptionKey() != null && !other.getEncryptionKey().equals(this.getEncryptionKey())) {
            return false;
        }
        if (other.getSizeBytes() == null ^ this.getSizeBytes() == null) {
            return false;
        }
        if (other.getSizeBytes() != null && !other.getSizeBytes().equals(this.getSizeBytes())) {
            return false;
        }
        if (other.getTermCount() == null ^ this.getTermCount() == null) {
            return false;
        }
        if (other.getTermCount() != null && !other.getTermCount().equals(this.getTermCount())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getLastUpdatedAt() == null ^ this.getLastUpdatedAt() == null) {
            return false;
        }
        if (other.getLastUpdatedAt() != null && !other.getLastUpdatedAt().equals(this.getLastUpdatedAt())) {
            return false;
        }
        if (other.getDirectionality() == null ^ this.getDirectionality() == null) {
            return false;
        }
        if (other.getDirectionality() != null && !other.getDirectionality().equals(this.getDirectionality())) {
            return false;
        }
        if (other.getMessage() == null ^ this.getMessage() == null) {
            return false;
        }
        if (other.getMessage() != null && !other.getMessage().equals(this.getMessage())) {
            return false;
        }
        if (other.getSkippedTermCount() == null ^ this.getSkippedTermCount() == null) {
            return false;
        }
        if (other.getSkippedTermCount() != null && !other.getSkippedTermCount().equals(this.getSkippedTermCount())) {
            return false;
        }
        if (other.getFormat() == null ^ this.getFormat() == null) {
            return false;
        }
        return other.getFormat() == null || other.getFormat().equals(this.getFormat());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getSourceLanguageCode() == null ? 0 : this.getSourceLanguageCode().hashCode());
        hashCode = 31 * hashCode + (this.getTargetLanguageCodes() == null ? 0 : this.getTargetLanguageCodes().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionKey() == null ? 0 : this.getEncryptionKey().hashCode());
        hashCode = 31 * hashCode + (this.getSizeBytes() == null ? 0 : this.getSizeBytes().hashCode());
        hashCode = 31 * hashCode + (this.getTermCount() == null ? 0 : this.getTermCount().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedAt() == null ? 0 : this.getLastUpdatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getDirectionality() == null ? 0 : this.getDirectionality().hashCode());
        hashCode = 31 * hashCode + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        hashCode = 31 * hashCode + (this.getSkippedTermCount() == null ? 0 : this.getSkippedTermCount().hashCode());
        hashCode = 31 * hashCode + (this.getFormat() == null ? 0 : this.getFormat().hashCode());
        return hashCode;
    }

    public TerminologyProperties clone() {
        try {
            return (TerminologyProperties)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TerminologyPropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

