/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.translate.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.translate.model.InputDataConfig;
import com.amazonaws.services.translate.model.JobDetails;
import com.amazonaws.services.translate.model.JobStatus;
import com.amazonaws.services.translate.model.OutputDataConfig;
import com.amazonaws.services.translate.model.transform.TextTranslationJobPropertiesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class TextTranslationJobProperties
implements Serializable,
Cloneable,
StructuredPojo {
    private String jobId;
    private String jobName;
    private String jobStatus;
    private JobDetails jobDetails;
    private String sourceLanguageCode;
    private List<String> targetLanguageCodes;
    private List<String> terminologyNames;
    private String message;
    private Date submittedTime;
    private Date endTime;
    private InputDataConfig inputDataConfig;
    private OutputDataConfig outputDataConfig;
    private String dataAccessRoleArn;

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public TextTranslationJobProperties withJobId(String jobId) {
        this.setJobId(jobId);
        return this;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public TextTranslationJobProperties withJobName(String jobName) {
        this.setJobName(jobName);
        return this;
    }

    public void setJobStatus(String jobStatus) {
        this.jobStatus = jobStatus;
    }

    public String getJobStatus() {
        return this.jobStatus;
    }

    public TextTranslationJobProperties withJobStatus(String jobStatus) {
        this.setJobStatus(jobStatus);
        return this;
    }

    public TextTranslationJobProperties withJobStatus(JobStatus jobStatus) {
        this.jobStatus = jobStatus.toString();
        return this;
    }

    public void setJobDetails(JobDetails jobDetails) {
        this.jobDetails = jobDetails;
    }

    public JobDetails getJobDetails() {
        return this.jobDetails;
    }

    public TextTranslationJobProperties withJobDetails(JobDetails jobDetails) {
        this.setJobDetails(jobDetails);
        return this;
    }

    public void setSourceLanguageCode(String sourceLanguageCode) {
        this.sourceLanguageCode = sourceLanguageCode;
    }

    public String getSourceLanguageCode() {
        return this.sourceLanguageCode;
    }

    public TextTranslationJobProperties withSourceLanguageCode(String sourceLanguageCode) {
        this.setSourceLanguageCode(sourceLanguageCode);
        return this;
    }

    public List<String> getTargetLanguageCodes() {
        return this.targetLanguageCodes;
    }

    public void setTargetLanguageCodes(Collection<String> targetLanguageCodes) {
        if (targetLanguageCodes == null) {
            this.targetLanguageCodes = null;
            return;
        }
        this.targetLanguageCodes = new ArrayList<String>(targetLanguageCodes);
    }

    public TextTranslationJobProperties withTargetLanguageCodes(String ... targetLanguageCodes) {
        if (this.targetLanguageCodes == null) {
            this.setTargetLanguageCodes(new ArrayList<String>(targetLanguageCodes.length));
        }
        for (String ele : targetLanguageCodes) {
            this.targetLanguageCodes.add(ele);
        }
        return this;
    }

    public TextTranslationJobProperties withTargetLanguageCodes(Collection<String> targetLanguageCodes) {
        this.setTargetLanguageCodes(targetLanguageCodes);
        return this;
    }

    public List<String> getTerminologyNames() {
        return this.terminologyNames;
    }

    public void setTerminologyNames(Collection<String> terminologyNames) {
        if (terminologyNames == null) {
            this.terminologyNames = null;
            return;
        }
        this.terminologyNames = new ArrayList<String>(terminologyNames);
    }

    public TextTranslationJobProperties withTerminologyNames(String ... terminologyNames) {
        if (this.terminologyNames == null) {
            this.setTerminologyNames(new ArrayList<String>(terminologyNames.length));
        }
        for (String ele : terminologyNames) {
            this.terminologyNames.add(ele);
        }
        return this;
    }

    public TextTranslationJobProperties withTerminologyNames(Collection<String> terminologyNames) {
        this.setTerminologyNames(terminologyNames);
        return this;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public TextTranslationJobProperties withMessage(String message) {
        this.setMessage(message);
        return this;
    }

    public void setSubmittedTime(Date submittedTime) {
        this.submittedTime = submittedTime;
    }

    public Date getSubmittedTime() {
        return this.submittedTime;
    }

    public TextTranslationJobProperties withSubmittedTime(Date submittedTime) {
        this.setSubmittedTime(submittedTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public TextTranslationJobProperties withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setInputDataConfig(InputDataConfig inputDataConfig) {
        this.inputDataConfig = inputDataConfig;
    }

    public InputDataConfig getInputDataConfig() {
        return this.inputDataConfig;
    }

    public TextTranslationJobProperties withInputDataConfig(InputDataConfig inputDataConfig) {
        this.setInputDataConfig(inputDataConfig);
        return this;
    }

    public void setOutputDataConfig(OutputDataConfig outputDataConfig) {
        this.outputDataConfig = outputDataConfig;
    }

    public OutputDataConfig getOutputDataConfig() {
        return this.outputDataConfig;
    }

    public TextTranslationJobProperties withOutputDataConfig(OutputDataConfig outputDataConfig) {
        this.setOutputDataConfig(outputDataConfig);
        return this;
    }

    public void setDataAccessRoleArn(String dataAccessRoleArn) {
        this.dataAccessRoleArn = dataAccessRoleArn;
    }

    public String getDataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public TextTranslationJobProperties withDataAccessRoleArn(String dataAccessRoleArn) {
        this.setDataAccessRoleArn(dataAccessRoleArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobId() != null) {
            sb.append("JobId: ").append(this.getJobId()).append(",");
        }
        if (this.getJobName() != null) {
            sb.append("JobName: ").append(this.getJobName()).append(",");
        }
        if (this.getJobStatus() != null) {
            sb.append("JobStatus: ").append(this.getJobStatus()).append(",");
        }
        if (this.getJobDetails() != null) {
            sb.append("JobDetails: ").append(this.getJobDetails()).append(",");
        }
        if (this.getSourceLanguageCode() != null) {
            sb.append("SourceLanguageCode: ").append(this.getSourceLanguageCode()).append(",");
        }
        if (this.getTargetLanguageCodes() != null) {
            sb.append("TargetLanguageCodes: ").append(this.getTargetLanguageCodes()).append(",");
        }
        if (this.getTerminologyNames() != null) {
            sb.append("TerminologyNames: ").append(this.getTerminologyNames()).append(",");
        }
        if (this.getMessage() != null) {
            sb.append("Message: ").append(this.getMessage()).append(",");
        }
        if (this.getSubmittedTime() != null) {
            sb.append("SubmittedTime: ").append(this.getSubmittedTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getInputDataConfig() != null) {
            sb.append("InputDataConfig: ").append(this.getInputDataConfig()).append(",");
        }
        if (this.getOutputDataConfig() != null) {
            sb.append("OutputDataConfig: ").append(this.getOutputDataConfig()).append(",");
        }
        if (this.getDataAccessRoleArn() != null) {
            sb.append("DataAccessRoleArn: ").append(this.getDataAccessRoleArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextTranslationJobProperties)) {
            return false;
        }
        TextTranslationJobProperties other = (TextTranslationJobProperties)obj;
        if (other.getJobId() == null ^ this.getJobId() == null) {
            return false;
        }
        if (other.getJobId() != null && !other.getJobId().equals(this.getJobId())) {
            return false;
        }
        if (other.getJobName() == null ^ this.getJobName() == null) {
            return false;
        }
        if (other.getJobName() != null && !other.getJobName().equals(this.getJobName())) {
            return false;
        }
        if (other.getJobStatus() == null ^ this.getJobStatus() == null) {
            return false;
        }
        if (other.getJobStatus() != null && !other.getJobStatus().equals(this.getJobStatus())) {
            return false;
        }
        if (other.getJobDetails() == null ^ this.getJobDetails() == null) {
            return false;
        }
        if (other.getJobDetails() != null && !other.getJobDetails().equals(this.getJobDetails())) {
            return false;
        }
        if (other.getSourceLanguageCode() == null ^ this.getSourceLanguageCode() == null) {
            return false;
        }
        if (other.getSourceLanguageCode() != null && !other.getSourceLanguageCode().equals(this.getSourceLanguageCode())) {
            return false;
        }
        if (other.getTargetLanguageCodes() == null ^ this.getTargetLanguageCodes() == null) {
            return false;
        }
        if (other.getTargetLanguageCodes() != null && !other.getTargetLanguageCodes().equals(this.getTargetLanguageCodes())) {
            return false;
        }
        if (other.getTerminologyNames() == null ^ this.getTerminologyNames() == null) {
            return false;
        }
        if (other.getTerminologyNames() != null && !other.getTerminologyNames().equals(this.getTerminologyNames())) {
            return false;
        }
        if (other.getMessage() == null ^ this.getMessage() == null) {
            return false;
        }
        if (other.getMessage() != null && !other.getMessage().equals(this.getMessage())) {
            return false;
        }
        if (other.getSubmittedTime() == null ^ this.getSubmittedTime() == null) {
            return false;
        }
        if (other.getSubmittedTime() != null && !other.getSubmittedTime().equals(this.getSubmittedTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getInputDataConfig() == null ^ this.getInputDataConfig() == null) {
            return false;
        }
        if (other.getInputDataConfig() != null && !other.getInputDataConfig().equals(this.getInputDataConfig())) {
            return false;
        }
        if (other.getOutputDataConfig() == null ^ this.getOutputDataConfig() == null) {
            return false;
        }
        if (other.getOutputDataConfig() != null && !other.getOutputDataConfig().equals(this.getOutputDataConfig())) {
            return false;
        }
        if (other.getDataAccessRoleArn() == null ^ this.getDataAccessRoleArn() == null) {
            return false;
        }
        return other.getDataAccessRoleArn() == null || other.getDataAccessRoleArn().equals(this.getDataAccessRoleArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobId() == null ? 0 : this.getJobId().hashCode());
        hashCode = 31 * hashCode + (this.getJobName() == null ? 0 : this.getJobName().hashCode());
        hashCode = 31 * hashCode + (this.getJobStatus() == null ? 0 : this.getJobStatus().hashCode());
        hashCode = 31 * hashCode + (this.getJobDetails() == null ? 0 : this.getJobDetails().hashCode());
        hashCode = 31 * hashCode + (this.getSourceLanguageCode() == null ? 0 : this.getSourceLanguageCode().hashCode());
        hashCode = 31 * hashCode + (this.getTargetLanguageCodes() == null ? 0 : this.getTargetLanguageCodes().hashCode());
        hashCode = 31 * hashCode + (this.getTerminologyNames() == null ? 0 : this.getTerminologyNames().hashCode());
        hashCode = 31 * hashCode + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        hashCode = 31 * hashCode + (this.getSubmittedTime() == null ? 0 : this.getSubmittedTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getInputDataConfig() == null ? 0 : this.getInputDataConfig().hashCode());
        hashCode = 31 * hashCode + (this.getOutputDataConfig() == null ? 0 : this.getOutputDataConfig().hashCode());
        hashCode = 31 * hashCode + (this.getDataAccessRoleArn() == null ? 0 : this.getDataAccessRoleArn().hashCode());
        return hashCode;
    }

    public TextTranslationJobProperties clone() {
        try {
            return (TextTranslationJobProperties)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TextTranslationJobPropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

