/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StartFileTransferRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String connectorId;
    private List<String> sendFilePaths;

    public void setConnectorId(String connectorId) {
        this.connectorId = connectorId;
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public StartFileTransferRequest withConnectorId(String connectorId) {
        this.setConnectorId(connectorId);
        return this;
    }

    public List<String> getSendFilePaths() {
        return this.sendFilePaths;
    }

    public void setSendFilePaths(Collection<String> sendFilePaths) {
        if (sendFilePaths == null) {
            this.sendFilePaths = null;
            return;
        }
        this.sendFilePaths = new ArrayList<String>(sendFilePaths);
    }

    public StartFileTransferRequest withSendFilePaths(String ... sendFilePaths) {
        if (this.sendFilePaths == null) {
            this.setSendFilePaths(new ArrayList<String>(sendFilePaths.length));
        }
        for (String ele : sendFilePaths) {
            this.sendFilePaths.add(ele);
        }
        return this;
    }

    public StartFileTransferRequest withSendFilePaths(Collection<String> sendFilePaths) {
        this.setSendFilePaths(sendFilePaths);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConnectorId() != null) {
            sb.append("ConnectorId: ").append(this.getConnectorId()).append(",");
        }
        if (this.getSendFilePaths() != null) {
            sb.append("SendFilePaths: ").append(this.getSendFilePaths());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartFileTransferRequest)) {
            return false;
        }
        StartFileTransferRequest other = (StartFileTransferRequest)obj;
        if (other.getConnectorId() == null ^ this.getConnectorId() == null) {
            return false;
        }
        if (other.getConnectorId() != null && !other.getConnectorId().equals(this.getConnectorId())) {
            return false;
        }
        if (other.getSendFilePaths() == null ^ this.getSendFilePaths() == null) {
            return false;
        }
        return other.getSendFilePaths() == null || other.getSendFilePaths().equals(this.getSendFilePaths());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConnectorId() == null ? 0 : this.getConnectorId().hashCode());
        hashCode = 31 * hashCode + (this.getSendFilePaths() == null ? 0 : this.getSendFilePaths().hashCode());
        return hashCode;
    }

    public StartFileTransferRequest clone() {
        return (StartFileTransferRequest)super.clone();
    }
}

