/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.transfer.model.HomeDirectoryMapEntry;
import com.amazonaws.services.transfer.model.HomeDirectoryType;
import com.amazonaws.services.transfer.model.PosixProfile;
import com.amazonaws.services.transfer.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateUserRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String homeDirectory;
    private String homeDirectoryType;
    private List<HomeDirectoryMapEntry> homeDirectoryMappings;
    private String policy;
    private PosixProfile posixProfile;
    private String role;
    private String serverId;
    private String sshPublicKeyBody;
    private List<Tag> tags;
    private String userName;

    public void setHomeDirectory(String homeDirectory) {
        this.homeDirectory = homeDirectory;
    }

    public String getHomeDirectory() {
        return this.homeDirectory;
    }

    public CreateUserRequest withHomeDirectory(String homeDirectory) {
        this.setHomeDirectory(homeDirectory);
        return this;
    }

    public void setHomeDirectoryType(String homeDirectoryType) {
        this.homeDirectoryType = homeDirectoryType;
    }

    public String getHomeDirectoryType() {
        return this.homeDirectoryType;
    }

    public CreateUserRequest withHomeDirectoryType(String homeDirectoryType) {
        this.setHomeDirectoryType(homeDirectoryType);
        return this;
    }

    public CreateUserRequest withHomeDirectoryType(HomeDirectoryType homeDirectoryType) {
        this.homeDirectoryType = homeDirectoryType.toString();
        return this;
    }

    public List<HomeDirectoryMapEntry> getHomeDirectoryMappings() {
        return this.homeDirectoryMappings;
    }

    public void setHomeDirectoryMappings(Collection<HomeDirectoryMapEntry> homeDirectoryMappings) {
        if (homeDirectoryMappings == null) {
            this.homeDirectoryMappings = null;
            return;
        }
        this.homeDirectoryMappings = new ArrayList<HomeDirectoryMapEntry>(homeDirectoryMappings);
    }

    public CreateUserRequest withHomeDirectoryMappings(HomeDirectoryMapEntry ... homeDirectoryMappings) {
        if (this.homeDirectoryMappings == null) {
            this.setHomeDirectoryMappings(new ArrayList<HomeDirectoryMapEntry>(homeDirectoryMappings.length));
        }
        for (HomeDirectoryMapEntry ele : homeDirectoryMappings) {
            this.homeDirectoryMappings.add(ele);
        }
        return this;
    }

    public CreateUserRequest withHomeDirectoryMappings(Collection<HomeDirectoryMapEntry> homeDirectoryMappings) {
        this.setHomeDirectoryMappings(homeDirectoryMappings);
        return this;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public String getPolicy() {
        return this.policy;
    }

    public CreateUserRequest withPolicy(String policy) {
        this.setPolicy(policy);
        return this;
    }

    public void setPosixProfile(PosixProfile posixProfile) {
        this.posixProfile = posixProfile;
    }

    public PosixProfile getPosixProfile() {
        return this.posixProfile;
    }

    public CreateUserRequest withPosixProfile(PosixProfile posixProfile) {
        this.setPosixProfile(posixProfile);
        return this;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getRole() {
        return this.role;
    }

    public CreateUserRequest withRole(String role) {
        this.setRole(role);
        return this;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String getServerId() {
        return this.serverId;
    }

    public CreateUserRequest withServerId(String serverId) {
        this.setServerId(serverId);
        return this;
    }

    public void setSshPublicKeyBody(String sshPublicKeyBody) {
        this.sshPublicKeyBody = sshPublicKeyBody;
    }

    public String getSshPublicKeyBody() {
        return this.sshPublicKeyBody;
    }

    public CreateUserRequest withSshPublicKeyBody(String sshPublicKeyBody) {
        this.setSshPublicKeyBody(sshPublicKeyBody);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateUserRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateUserRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public CreateUserRequest withUserName(String userName) {
        this.setUserName(userName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHomeDirectory() != null) {
            sb.append("HomeDirectory: ").append(this.getHomeDirectory()).append(",");
        }
        if (this.getHomeDirectoryType() != null) {
            sb.append("HomeDirectoryType: ").append(this.getHomeDirectoryType()).append(",");
        }
        if (this.getHomeDirectoryMappings() != null) {
            sb.append("HomeDirectoryMappings: ").append(this.getHomeDirectoryMappings()).append(",");
        }
        if (this.getPolicy() != null) {
            sb.append("Policy: ").append(this.getPolicy()).append(",");
        }
        if (this.getPosixProfile() != null) {
            sb.append("PosixProfile: ").append(this.getPosixProfile()).append(",");
        }
        if (this.getRole() != null) {
            sb.append("Role: ").append(this.getRole()).append(",");
        }
        if (this.getServerId() != null) {
            sb.append("ServerId: ").append(this.getServerId()).append(",");
        }
        if (this.getSshPublicKeyBody() != null) {
            sb.append("SshPublicKeyBody: ").append(this.getSshPublicKeyBody()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getUserName() != null) {
            sb.append("UserName: ").append(this.getUserName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserRequest)) {
            return false;
        }
        CreateUserRequest other = (CreateUserRequest)obj;
        if (other.getHomeDirectory() == null ^ this.getHomeDirectory() == null) {
            return false;
        }
        if (other.getHomeDirectory() != null && !other.getHomeDirectory().equals(this.getHomeDirectory())) {
            return false;
        }
        if (other.getHomeDirectoryType() == null ^ this.getHomeDirectoryType() == null) {
            return false;
        }
        if (other.getHomeDirectoryType() != null && !other.getHomeDirectoryType().equals(this.getHomeDirectoryType())) {
            return false;
        }
        if (other.getHomeDirectoryMappings() == null ^ this.getHomeDirectoryMappings() == null) {
            return false;
        }
        if (other.getHomeDirectoryMappings() != null && !other.getHomeDirectoryMappings().equals(this.getHomeDirectoryMappings())) {
            return false;
        }
        if (other.getPolicy() == null ^ this.getPolicy() == null) {
            return false;
        }
        if (other.getPolicy() != null && !other.getPolicy().equals(this.getPolicy())) {
            return false;
        }
        if (other.getPosixProfile() == null ^ this.getPosixProfile() == null) {
            return false;
        }
        if (other.getPosixProfile() != null && !other.getPosixProfile().equals(this.getPosixProfile())) {
            return false;
        }
        if (other.getRole() == null ^ this.getRole() == null) {
            return false;
        }
        if (other.getRole() != null && !other.getRole().equals(this.getRole())) {
            return false;
        }
        if (other.getServerId() == null ^ this.getServerId() == null) {
            return false;
        }
        if (other.getServerId() != null && !other.getServerId().equals(this.getServerId())) {
            return false;
        }
        if (other.getSshPublicKeyBody() == null ^ this.getSshPublicKeyBody() == null) {
            return false;
        }
        if (other.getSshPublicKeyBody() != null && !other.getSshPublicKeyBody().equals(this.getSshPublicKeyBody())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getUserName() == null ^ this.getUserName() == null) {
            return false;
        }
        return other.getUserName() == null || other.getUserName().equals(this.getUserName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHomeDirectory() == null ? 0 : this.getHomeDirectory().hashCode());
        hashCode = 31 * hashCode + (this.getHomeDirectoryType() == null ? 0 : this.getHomeDirectoryType().hashCode());
        hashCode = 31 * hashCode + (this.getHomeDirectoryMappings() == null ? 0 : this.getHomeDirectoryMappings().hashCode());
        hashCode = 31 * hashCode + (this.getPolicy() == null ? 0 : this.getPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getPosixProfile() == null ? 0 : this.getPosixProfile().hashCode());
        hashCode = 31 * hashCode + (this.getRole() == null ? 0 : this.getRole().hashCode());
        hashCode = 31 * hashCode + (this.getServerId() == null ? 0 : this.getServerId().hashCode());
        hashCode = 31 * hashCode + (this.getSshPublicKeyBody() == null ? 0 : this.getSshPublicKeyBody().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getUserName() == null ? 0 : this.getUserName().hashCode());
        return hashCode;
    }

    public CreateUserRequest clone() {
        return (CreateUserRequest)super.clone();
    }
}

