/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.transcribe.model.LanguageCode;
import com.amazonaws.services.transcribe.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateVocabularyRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String vocabularyName;
    private String languageCode;
    private List<String> phrases;
    private String vocabularyFileUri;
    private List<Tag> tags;

    public void setVocabularyName(String vocabularyName) {
        this.vocabularyName = vocabularyName;
    }

    public String getVocabularyName() {
        return this.vocabularyName;
    }

    public CreateVocabularyRequest withVocabularyName(String vocabularyName) {
        this.setVocabularyName(vocabularyName);
        return this;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public CreateVocabularyRequest withLanguageCode(String languageCode) {
        this.setLanguageCode(languageCode);
        return this;
    }

    public CreateVocabularyRequest withLanguageCode(LanguageCode languageCode) {
        this.languageCode = languageCode.toString();
        return this;
    }

    public List<String> getPhrases() {
        return this.phrases;
    }

    public void setPhrases(Collection<String> phrases) {
        if (phrases == null) {
            this.phrases = null;
            return;
        }
        this.phrases = new ArrayList<String>(phrases);
    }

    public CreateVocabularyRequest withPhrases(String ... phrases) {
        if (this.phrases == null) {
            this.setPhrases(new ArrayList<String>(phrases.length));
        }
        for (String ele : phrases) {
            this.phrases.add(ele);
        }
        return this;
    }

    public CreateVocabularyRequest withPhrases(Collection<String> phrases) {
        this.setPhrases(phrases);
        return this;
    }

    public void setVocabularyFileUri(String vocabularyFileUri) {
        this.vocabularyFileUri = vocabularyFileUri;
    }

    public String getVocabularyFileUri() {
        return this.vocabularyFileUri;
    }

    public CreateVocabularyRequest withVocabularyFileUri(String vocabularyFileUri) {
        this.setVocabularyFileUri(vocabularyFileUri);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateVocabularyRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateVocabularyRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVocabularyName() != null) {
            sb.append("VocabularyName: ").append(this.getVocabularyName()).append(",");
        }
        if (this.getLanguageCode() != null) {
            sb.append("LanguageCode: ").append(this.getLanguageCode()).append(",");
        }
        if (this.getPhrases() != null) {
            sb.append("Phrases: ").append(this.getPhrases()).append(",");
        }
        if (this.getVocabularyFileUri() != null) {
            sb.append("VocabularyFileUri: ").append(this.getVocabularyFileUri()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVocabularyRequest)) {
            return false;
        }
        CreateVocabularyRequest other = (CreateVocabularyRequest)obj;
        if (other.getVocabularyName() == null ^ this.getVocabularyName() == null) {
            return false;
        }
        if (other.getVocabularyName() != null && !other.getVocabularyName().equals(this.getVocabularyName())) {
            return false;
        }
        if (other.getLanguageCode() == null ^ this.getLanguageCode() == null) {
            return false;
        }
        if (other.getLanguageCode() != null && !other.getLanguageCode().equals(this.getLanguageCode())) {
            return false;
        }
        if (other.getPhrases() == null ^ this.getPhrases() == null) {
            return false;
        }
        if (other.getPhrases() != null && !other.getPhrases().equals(this.getPhrases())) {
            return false;
        }
        if (other.getVocabularyFileUri() == null ^ this.getVocabularyFileUri() == null) {
            return false;
        }
        if (other.getVocabularyFileUri() != null && !other.getVocabularyFileUri().equals(this.getVocabularyFileUri())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVocabularyName() == null ? 0 : this.getVocabularyName().hashCode());
        hashCode = 31 * hashCode + (this.getLanguageCode() == null ? 0 : this.getLanguageCode().hashCode());
        hashCode = 31 * hashCode + (this.getPhrases() == null ? 0 : this.getPhrases().hashCode());
        hashCode = 31 * hashCode + (this.getVocabularyFileUri() == null ? 0 : this.getVocabularyFileUri().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateVocabularyRequest clone() {
        return (CreateVocabularyRequest)super.clone();
    }
}

