/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.transcribe.model.ToxicityCategory;
import com.amazonaws.services.transcribe.model.transform.ToxicityDetectionSettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ToxicityDetectionSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> toxicityCategories;

    public List<String> getToxicityCategories() {
        return this.toxicityCategories;
    }

    public void setToxicityCategories(Collection<String> toxicityCategories) {
        if (toxicityCategories == null) {
            this.toxicityCategories = null;
            return;
        }
        this.toxicityCategories = new ArrayList<String>(toxicityCategories);
    }

    public ToxicityDetectionSettings withToxicityCategories(String ... toxicityCategories) {
        if (this.toxicityCategories == null) {
            this.setToxicityCategories(new ArrayList<String>(toxicityCategories.length));
        }
        for (String ele : toxicityCategories) {
            this.toxicityCategories.add(ele);
        }
        return this;
    }

    public ToxicityDetectionSettings withToxicityCategories(Collection<String> toxicityCategories) {
        this.setToxicityCategories(toxicityCategories);
        return this;
    }

    public ToxicityDetectionSettings withToxicityCategories(ToxicityCategory ... toxicityCategories) {
        ArrayList<String> toxicityCategoriesCopy = new ArrayList<String>(toxicityCategories.length);
        for (ToxicityCategory value : toxicityCategories) {
            toxicityCategoriesCopy.add(value.toString());
        }
        if (this.getToxicityCategories() == null) {
            this.setToxicityCategories(toxicityCategoriesCopy);
        } else {
            this.getToxicityCategories().addAll(toxicityCategoriesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getToxicityCategories() != null) {
            sb.append("ToxicityCategories: ").append(this.getToxicityCategories());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToxicityDetectionSettings)) {
            return false;
        }
        ToxicityDetectionSettings other = (ToxicityDetectionSettings)obj;
        if (other.getToxicityCategories() == null ^ this.getToxicityCategories() == null) {
            return false;
        }
        return other.getToxicityCategories() == null || other.getToxicityCategories().equals(this.getToxicityCategories());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getToxicityCategories() == null ? 0 : this.getToxicityCategories().hashCode());
        return hashCode;
    }

    public ToxicityDetectionSettings clone() {
        try {
            return (ToxicityDetectionSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ToxicityDetectionSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

