/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.timestreamquery.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.timestreamquery.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * TimestreamConfiguration JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class TimestreamConfigurationJsonUnmarshaller implements Unmarshaller<TimestreamConfiguration, JsonUnmarshallerContext> {

    public TimestreamConfiguration unmarshall(JsonUnmarshallerContext context) throws Exception {
        TimestreamConfiguration timestreamConfiguration = new TimestreamConfiguration();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("DatabaseName", targetDepth)) {
                    context.nextToken();
                    timestreamConfiguration.setDatabaseName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("TableName", targetDepth)) {
                    context.nextToken();
                    timestreamConfiguration.setTableName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("TimeColumn", targetDepth)) {
                    context.nextToken();
                    timestreamConfiguration.setTimeColumn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DimensionMappings", targetDepth)) {
                    context.nextToken();
                    timestreamConfiguration.setDimensionMappings(new ListUnmarshaller<DimensionMapping>(DimensionMappingJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("MultiMeasureMappings", targetDepth)) {
                    context.nextToken();
                    timestreamConfiguration.setMultiMeasureMappings(MultiMeasureMappingsJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("MixedMeasureMappings", targetDepth)) {
                    context.nextToken();
                    timestreamConfiguration
                            .setMixedMeasureMappings(new ListUnmarshaller<MixedMeasureMapping>(MixedMeasureMappingJsonUnmarshaller.getInstance())

                            .unmarshall(context));
                }
                if (context.testExpression("MeasureNameColumn", targetDepth)) {
                    context.nextToken();
                    timestreamConfiguration.setMeasureNameColumn(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return timestreamConfiguration;
    }

    private static TimestreamConfigurationJsonUnmarshaller instance;

    public static TimestreamConfigurationJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new TimestreamConfigurationJsonUnmarshaller();
        return instance;
    }
}
