/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamquery.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.timestreamquery.model.ErrorReportConfiguration;
import com.amazonaws.services.timestreamquery.model.NotificationConfiguration;
import com.amazonaws.services.timestreamquery.model.ScheduleConfiguration;
import com.amazonaws.services.timestreamquery.model.ScheduledQueryRunSummary;
import com.amazonaws.services.timestreamquery.model.ScheduledQueryState;
import com.amazonaws.services.timestreamquery.model.TargetConfiguration;
import com.amazonaws.services.timestreamquery.model.transform.ScheduledQueryDescriptionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ScheduledQueryDescription
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private String name;
    private String queryString;
    private Date creationTime;
    private String state;
    private Date previousInvocationTime;
    private Date nextInvocationTime;
    private ScheduleConfiguration scheduleConfiguration;
    private NotificationConfiguration notificationConfiguration;
    private TargetConfiguration targetConfiguration;
    private String scheduledQueryExecutionRoleArn;
    private String kmsKeyId;
    private ErrorReportConfiguration errorReportConfiguration;
    private ScheduledQueryRunSummary lastRunSummary;
    private List<ScheduledQueryRunSummary> recentlyFailedRuns;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public ScheduledQueryDescription withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ScheduledQueryDescription withName(String name) {
        this.setName(name);
        return this;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public ScheduledQueryDescription withQueryString(String queryString) {
        this.setQueryString(queryString);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public ScheduledQueryDescription withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public ScheduledQueryDescription withState(String state) {
        this.setState(state);
        return this;
    }

    public ScheduledQueryDescription withState(ScheduledQueryState state) {
        this.state = state.toString();
        return this;
    }

    public void setPreviousInvocationTime(Date previousInvocationTime) {
        this.previousInvocationTime = previousInvocationTime;
    }

    public Date getPreviousInvocationTime() {
        return this.previousInvocationTime;
    }

    public ScheduledQueryDescription withPreviousInvocationTime(Date previousInvocationTime) {
        this.setPreviousInvocationTime(previousInvocationTime);
        return this;
    }

    public void setNextInvocationTime(Date nextInvocationTime) {
        this.nextInvocationTime = nextInvocationTime;
    }

    public Date getNextInvocationTime() {
        return this.nextInvocationTime;
    }

    public ScheduledQueryDescription withNextInvocationTime(Date nextInvocationTime) {
        this.setNextInvocationTime(nextInvocationTime);
        return this;
    }

    public void setScheduleConfiguration(ScheduleConfiguration scheduleConfiguration) {
        this.scheduleConfiguration = scheduleConfiguration;
    }

    public ScheduleConfiguration getScheduleConfiguration() {
        return this.scheduleConfiguration;
    }

    public ScheduledQueryDescription withScheduleConfiguration(ScheduleConfiguration scheduleConfiguration) {
        this.setScheduleConfiguration(scheduleConfiguration);
        return this;
    }

    public void setNotificationConfiguration(NotificationConfiguration notificationConfiguration) {
        this.notificationConfiguration = notificationConfiguration;
    }

    public NotificationConfiguration getNotificationConfiguration() {
        return this.notificationConfiguration;
    }

    public ScheduledQueryDescription withNotificationConfiguration(NotificationConfiguration notificationConfiguration) {
        this.setNotificationConfiguration(notificationConfiguration);
        return this;
    }

    public void setTargetConfiguration(TargetConfiguration targetConfiguration) {
        this.targetConfiguration = targetConfiguration;
    }

    public TargetConfiguration getTargetConfiguration() {
        return this.targetConfiguration;
    }

    public ScheduledQueryDescription withTargetConfiguration(TargetConfiguration targetConfiguration) {
        this.setTargetConfiguration(targetConfiguration);
        return this;
    }

    public void setScheduledQueryExecutionRoleArn(String scheduledQueryExecutionRoleArn) {
        this.scheduledQueryExecutionRoleArn = scheduledQueryExecutionRoleArn;
    }

    public String getScheduledQueryExecutionRoleArn() {
        return this.scheduledQueryExecutionRoleArn;
    }

    public ScheduledQueryDescription withScheduledQueryExecutionRoleArn(String scheduledQueryExecutionRoleArn) {
        this.setScheduledQueryExecutionRoleArn(scheduledQueryExecutionRoleArn);
        return this;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public ScheduledQueryDescription withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public void setErrorReportConfiguration(ErrorReportConfiguration errorReportConfiguration) {
        this.errorReportConfiguration = errorReportConfiguration;
    }

    public ErrorReportConfiguration getErrorReportConfiguration() {
        return this.errorReportConfiguration;
    }

    public ScheduledQueryDescription withErrorReportConfiguration(ErrorReportConfiguration errorReportConfiguration) {
        this.setErrorReportConfiguration(errorReportConfiguration);
        return this;
    }

    public void setLastRunSummary(ScheduledQueryRunSummary lastRunSummary) {
        this.lastRunSummary = lastRunSummary;
    }

    public ScheduledQueryRunSummary getLastRunSummary() {
        return this.lastRunSummary;
    }

    public ScheduledQueryDescription withLastRunSummary(ScheduledQueryRunSummary lastRunSummary) {
        this.setLastRunSummary(lastRunSummary);
        return this;
    }

    public List<ScheduledQueryRunSummary> getRecentlyFailedRuns() {
        return this.recentlyFailedRuns;
    }

    public void setRecentlyFailedRuns(Collection<ScheduledQueryRunSummary> recentlyFailedRuns) {
        if (recentlyFailedRuns == null) {
            this.recentlyFailedRuns = null;
            return;
        }
        this.recentlyFailedRuns = new ArrayList<ScheduledQueryRunSummary>(recentlyFailedRuns);
    }

    public ScheduledQueryDescription withRecentlyFailedRuns(ScheduledQueryRunSummary ... recentlyFailedRuns) {
        if (this.recentlyFailedRuns == null) {
            this.setRecentlyFailedRuns(new ArrayList<ScheduledQueryRunSummary>(recentlyFailedRuns.length));
        }
        for (ScheduledQueryRunSummary ele : recentlyFailedRuns) {
            this.recentlyFailedRuns.add(ele);
        }
        return this;
    }

    public ScheduledQueryDescription withRecentlyFailedRuns(Collection<ScheduledQueryRunSummary> recentlyFailedRuns) {
        this.setRecentlyFailedRuns(recentlyFailedRuns);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getQueryString() != null) {
            sb.append("QueryString: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getPreviousInvocationTime() != null) {
            sb.append("PreviousInvocationTime: ").append(this.getPreviousInvocationTime()).append(",");
        }
        if (this.getNextInvocationTime() != null) {
            sb.append("NextInvocationTime: ").append(this.getNextInvocationTime()).append(",");
        }
        if (this.getScheduleConfiguration() != null) {
            sb.append("ScheduleConfiguration: ").append(this.getScheduleConfiguration()).append(",");
        }
        if (this.getNotificationConfiguration() != null) {
            sb.append("NotificationConfiguration: ").append(this.getNotificationConfiguration()).append(",");
        }
        if (this.getTargetConfiguration() != null) {
            sb.append("TargetConfiguration: ").append(this.getTargetConfiguration()).append(",");
        }
        if (this.getScheduledQueryExecutionRoleArn() != null) {
            sb.append("ScheduledQueryExecutionRoleArn: ").append(this.getScheduledQueryExecutionRoleArn()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getErrorReportConfiguration() != null) {
            sb.append("ErrorReportConfiguration: ").append(this.getErrorReportConfiguration()).append(",");
        }
        if (this.getLastRunSummary() != null) {
            sb.append("LastRunSummary: ").append(this.getLastRunSummary()).append(",");
        }
        if (this.getRecentlyFailedRuns() != null) {
            sb.append("RecentlyFailedRuns: ").append(this.getRecentlyFailedRuns());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledQueryDescription)) {
            return false;
        }
        ScheduledQueryDescription other = (ScheduledQueryDescription)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getQueryString() == null ^ this.getQueryString() == null) {
            return false;
        }
        if (other.getQueryString() != null && !other.getQueryString().equals(this.getQueryString())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getPreviousInvocationTime() == null ^ this.getPreviousInvocationTime() == null) {
            return false;
        }
        if (other.getPreviousInvocationTime() != null && !other.getPreviousInvocationTime().equals(this.getPreviousInvocationTime())) {
            return false;
        }
        if (other.getNextInvocationTime() == null ^ this.getNextInvocationTime() == null) {
            return false;
        }
        if (other.getNextInvocationTime() != null && !other.getNextInvocationTime().equals(this.getNextInvocationTime())) {
            return false;
        }
        if (other.getScheduleConfiguration() == null ^ this.getScheduleConfiguration() == null) {
            return false;
        }
        if (other.getScheduleConfiguration() != null && !other.getScheduleConfiguration().equals(this.getScheduleConfiguration())) {
            return false;
        }
        if (other.getNotificationConfiguration() == null ^ this.getNotificationConfiguration() == null) {
            return false;
        }
        if (other.getNotificationConfiguration() != null && !other.getNotificationConfiguration().equals(this.getNotificationConfiguration())) {
            return false;
        }
        if (other.getTargetConfiguration() == null ^ this.getTargetConfiguration() == null) {
            return false;
        }
        if (other.getTargetConfiguration() != null && !other.getTargetConfiguration().equals(this.getTargetConfiguration())) {
            return false;
        }
        if (other.getScheduledQueryExecutionRoleArn() == null ^ this.getScheduledQueryExecutionRoleArn() == null) {
            return false;
        }
        if (other.getScheduledQueryExecutionRoleArn() != null && !other.getScheduledQueryExecutionRoleArn().equals(this.getScheduledQueryExecutionRoleArn())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getErrorReportConfiguration() == null ^ this.getErrorReportConfiguration() == null) {
            return false;
        }
        if (other.getErrorReportConfiguration() != null && !other.getErrorReportConfiguration().equals(this.getErrorReportConfiguration())) {
            return false;
        }
        if (other.getLastRunSummary() == null ^ this.getLastRunSummary() == null) {
            return false;
        }
        if (other.getLastRunSummary() != null && !other.getLastRunSummary().equals(this.getLastRunSummary())) {
            return false;
        }
        if (other.getRecentlyFailedRuns() == null ^ this.getRecentlyFailedRuns() == null) {
            return false;
        }
        return other.getRecentlyFailedRuns() == null || other.getRecentlyFailedRuns().equals(this.getRecentlyFailedRuns());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getQueryString() == null ? 0 : this.getQueryString().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getPreviousInvocationTime() == null ? 0 : this.getPreviousInvocationTime().hashCode());
        hashCode = 31 * hashCode + (this.getNextInvocationTime() == null ? 0 : this.getNextInvocationTime().hashCode());
        hashCode = 31 * hashCode + (this.getScheduleConfiguration() == null ? 0 : this.getScheduleConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationConfiguration() == null ? 0 : this.getNotificationConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getTargetConfiguration() == null ? 0 : this.getTargetConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getScheduledQueryExecutionRoleArn() == null ? 0 : this.getScheduledQueryExecutionRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getErrorReportConfiguration() == null ? 0 : this.getErrorReportConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getLastRunSummary() == null ? 0 : this.getLastRunSummary().hashCode());
        hashCode = 31 * hashCode + (this.getRecentlyFailedRuns() == null ? 0 : this.getRecentlyFailedRuns().hashCode());
        return hashCode;
    }

    public ScheduledQueryDescription clone() {
        try {
            return (ScheduledQueryDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScheduledQueryDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

