/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.textract.model.Prediction;
import com.amazonaws.services.textract.model.transform.PageClassificationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PageClassification
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Prediction> pageType;
    private List<Prediction> pageNumber;

    public List<Prediction> getPageType() {
        return this.pageType;
    }

    public void setPageType(Collection<Prediction> pageType) {
        if (pageType == null) {
            this.pageType = null;
            return;
        }
        this.pageType = new ArrayList<Prediction>(pageType);
    }

    public PageClassification withPageType(Prediction ... pageType) {
        if (this.pageType == null) {
            this.setPageType(new ArrayList<Prediction>(pageType.length));
        }
        for (Prediction ele : pageType) {
            this.pageType.add(ele);
        }
        return this;
    }

    public PageClassification withPageType(Collection<Prediction> pageType) {
        this.setPageType(pageType);
        return this;
    }

    public List<Prediction> getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Collection<Prediction> pageNumber) {
        if (pageNumber == null) {
            this.pageNumber = null;
            return;
        }
        this.pageNumber = new ArrayList<Prediction>(pageNumber);
    }

    public PageClassification withPageNumber(Prediction ... pageNumber) {
        if (this.pageNumber == null) {
            this.setPageNumber(new ArrayList<Prediction>(pageNumber.length));
        }
        for (Prediction ele : pageNumber) {
            this.pageNumber.add(ele);
        }
        return this;
    }

    public PageClassification withPageNumber(Collection<Prediction> pageNumber) {
        this.setPageNumber(pageNumber);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPageType() != null) {
            sb.append("PageType: ").append(this.getPageType()).append(",");
        }
        if (this.getPageNumber() != null) {
            sb.append("PageNumber: ").append(this.getPageNumber());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PageClassification)) {
            return false;
        }
        PageClassification other = (PageClassification)obj;
        if (other.getPageType() == null ^ this.getPageType() == null) {
            return false;
        }
        if (other.getPageType() != null && !other.getPageType().equals(this.getPageType())) {
            return false;
        }
        if (other.getPageNumber() == null ^ this.getPageNumber() == null) {
            return false;
        }
        return other.getPageNumber() == null || other.getPageNumber().equals(this.getPageNumber());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPageType() == null ? 0 : this.getPageType().hashCode());
        hashCode = 31 * hashCode + (this.getPageNumber() == null ? 0 : this.getPageNumber().hashCode());
        return hashCode;
    }

    public PageClassification clone() {
        try {
            return (PageClassification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PageClassificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

