/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.textract.model.AdapterVersionStatus;
import com.amazonaws.services.textract.model.FeatureType;
import com.amazonaws.services.textract.model.transform.AdapterVersionOverviewMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class AdapterVersionOverview
implements Serializable,
Cloneable,
StructuredPojo {
    private String adapterId;
    private String adapterVersion;
    private Date creationTime;
    private List<String> featureTypes;
    private String status;
    private String statusMessage;

    public void setAdapterId(String adapterId) {
        this.adapterId = adapterId;
    }

    public String getAdapterId() {
        return this.adapterId;
    }

    public AdapterVersionOverview withAdapterId(String adapterId) {
        this.setAdapterId(adapterId);
        return this;
    }

    public void setAdapterVersion(String adapterVersion) {
        this.adapterVersion = adapterVersion;
    }

    public String getAdapterVersion() {
        return this.adapterVersion;
    }

    public AdapterVersionOverview withAdapterVersion(String adapterVersion) {
        this.setAdapterVersion(adapterVersion);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public AdapterVersionOverview withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public List<String> getFeatureTypes() {
        return this.featureTypes;
    }

    public void setFeatureTypes(Collection<String> featureTypes) {
        if (featureTypes == null) {
            this.featureTypes = null;
            return;
        }
        this.featureTypes = new ArrayList<String>(featureTypes);
    }

    public AdapterVersionOverview withFeatureTypes(String ... featureTypes) {
        if (this.featureTypes == null) {
            this.setFeatureTypes(new ArrayList<String>(featureTypes.length));
        }
        for (String ele : featureTypes) {
            this.featureTypes.add(ele);
        }
        return this;
    }

    public AdapterVersionOverview withFeatureTypes(Collection<String> featureTypes) {
        this.setFeatureTypes(featureTypes);
        return this;
    }

    public AdapterVersionOverview withFeatureTypes(FeatureType ... featureTypes) {
        ArrayList<String> featureTypesCopy = new ArrayList<String>(featureTypes.length);
        for (FeatureType value : featureTypes) {
            featureTypesCopy.add(value.toString());
        }
        if (this.getFeatureTypes() == null) {
            this.setFeatureTypes(featureTypesCopy);
        } else {
            this.getFeatureTypes().addAll(featureTypesCopy);
        }
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public AdapterVersionOverview withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public AdapterVersionOverview withStatus(AdapterVersionStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public AdapterVersionOverview withStatusMessage(String statusMessage) {
        this.setStatusMessage(statusMessage);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAdapterId() != null) {
            sb.append("AdapterId: ").append(this.getAdapterId()).append(",");
        }
        if (this.getAdapterVersion() != null) {
            sb.append("AdapterVersion: ").append(this.getAdapterVersion()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getFeatureTypes() != null) {
            sb.append("FeatureTypes: ").append(this.getFeatureTypes()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getStatusMessage() != null) {
            sb.append("StatusMessage: ").append(this.getStatusMessage());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdapterVersionOverview)) {
            return false;
        }
        AdapterVersionOverview other = (AdapterVersionOverview)obj;
        if (other.getAdapterId() == null ^ this.getAdapterId() == null) {
            return false;
        }
        if (other.getAdapterId() != null && !other.getAdapterId().equals(this.getAdapterId())) {
            return false;
        }
        if (other.getAdapterVersion() == null ^ this.getAdapterVersion() == null) {
            return false;
        }
        if (other.getAdapterVersion() != null && !other.getAdapterVersion().equals(this.getAdapterVersion())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getFeatureTypes() == null ^ this.getFeatureTypes() == null) {
            return false;
        }
        if (other.getFeatureTypes() != null && !other.getFeatureTypes().equals(this.getFeatureTypes())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getStatusMessage() == null ^ this.getStatusMessage() == null) {
            return false;
        }
        return other.getStatusMessage() == null || other.getStatusMessage().equals(this.getStatusMessage());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAdapterId() == null ? 0 : this.getAdapterId().hashCode());
        hashCode = 31 * hashCode + (this.getAdapterVersion() == null ? 0 : this.getAdapterVersion().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getFeatureTypes() == null ? 0 : this.getFeatureTypes().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStatusMessage() == null ? 0 : this.getStatusMessage().hashCode());
        return hashCode;
    }

    public AdapterVersionOverview clone() {
        try {
            return (AdapterVersionOverview)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AdapterVersionOverviewMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

