/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.test;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.PropertiesFileCredentialsProvider;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.junit.Assert;

public abstract class AWSTestBase {
    public static AWSCredentials credentials;
    private static final String propertiesFilePath;
    private static final String TEST_CREDENTIALS_PROFILE_NAME = "aws-java-sdk-test";
    private static final AWSCredentialsProviderChain chain;

    public static void setUpCredentials() throws FileNotFoundException, IOException {
        if (credentials == null) {
            credentials = chain.getCredentials();
        }
    }

    protected void assertNotEmpty(String str) {
        Assert.assertNotNull((Object)str);
        Assert.assertTrue((str.length() > 0 ? 1 : 0) != 0);
    }

    protected void assertFileEqualsStream(File expected, InputStream actual) {
        this.assertFileEqualsStream(null, expected, actual);
    }

    protected void assertFileEqualsStream(String errmsg, File expected, InputStream actual) {
        try {
            FileInputStream expectedInputStream = new FileInputStream(expected);
            this.assertStreamEqualsStream(errmsg, expectedInputStream, actual);
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)("Expected file " + expected.getAbsolutePath() + " doesn't exist: " + e.getMessage()));
        }
    }

    protected void assertStreamEqualsStream(InputStream expected, InputStream actual) {
        this.assertStreamEqualsStream(null, expected, actual);
    }

    protected void assertStreamEqualsStream(String errmsg, InputStream expectedInputStream, InputStream inputStream) {
        try {
            Assert.assertTrue((String)errmsg, (boolean)this.doesStreamEqualStream(expectedInputStream, inputStream));
        }
        catch (IOException e) {
            Assert.fail((String)("Error reading from stream: " + e.getMessage()));
        }
    }

    protected void assertFileEqualsFile(File expected, File actual) {
        if (expected == null || !expected.exists()) {
            Assert.fail((String)"Expected file doesn't exist");
        }
        if (actual == null || !actual.exists()) {
            Assert.fail((String)"Actual file doesn't exist");
        }
        long expectedFileLen = expected.length();
        long fileLen = actual.length();
        Assert.assertTrue((String)("expectedFileLen=" + expectedFileLen + ", fileLen=" + fileLen + ", expectedFile=" + expected + ", file=" + actual), (expectedFileLen == fileLen ? 1 : 0) != 0);
        try {
            this.assertStreamEqualsStream("expected file: " + expected + " vs. actual file: " + actual, new FileInputStream(expected), new FileInputStream(actual));
        }
        catch (Exception e) {
            Assert.fail((String)("Unable to compare files: " + e.getMessage()));
        }
    }

    protected void assertStringEqualsStream(String expected, InputStream actual) {
        try {
            ByteArrayInputStream expectedInputStream = new ByteArrayInputStream(expected.getBytes());
            Assert.assertTrue((boolean)this.doesStreamEqualStream(expectedInputStream, actual));
        }
        catch (IOException e) {
            Assert.fail((String)("Error reading from stream: " + e.getMessage()));
        }
    }

    protected boolean doesStreamEqualStream(InputStream expected, InputStream actual) throws IOException {
        try {
            byte[] expectedDigest = this.calculateMD5Digest(expected);
            byte[] actualDigest = this.calculateMD5Digest(actual);
            boolean bl = Arrays.equals(expectedDigest, actualDigest);
            return bl;
        }
        catch (NoSuchAlgorithmException nse) {
            throw new AmazonClientException(nse.getMessage(), (Throwable)nse);
        }
        finally {
            IOUtils.closeQuietly((Closeable)expected, null);
            IOUtils.closeQuietly((Closeable)actual, null);
        }
    }

    private byte[] calculateMD5Digest(InputStream is) throws NoSuchAlgorithmException, IOException {
        int bytesRead = 0;
        byte[] buffer = new byte[2048];
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        while ((bytesRead = is.read(buffer)) != -1) {
            md5.update(buffer, 0, bytesRead);
        }
        return md5.digest();
    }

    protected byte[] drainInputStream(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[1024];
            long bytesRead = 0L;
            while ((bytesRead = (long)inputStream.read(buffer)) > -1L) {
                byteArrayOutputStream.write(buffer, 0, (int)bytesRead);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)byteArrayOutputStream, null);
        }
    }

    protected boolean doesFileEqualStream(File expectedFile, InputStream inputStream) throws IOException {
        FileInputStream expectedInputStream = new FileInputStream(expectedFile);
        return this.doesStreamEqualStream(expectedInputStream, inputStream);
    }

    protected void assertValidException(AmazonServiceException e) {
        Assert.assertNotNull((Object)e.getRequestId());
        Assert.assertTrue((e.getRequestId().trim().length() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)e.getMessage());
        Assert.assertTrue((e.getMessage().trim().length() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)e.getErrorCode());
        Assert.assertTrue((e.getErrorCode().trim().length() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)e.getServiceName());
        Assert.assertTrue((boolean)e.getServiceName().startsWith("Amazon"));
    }

    static {
        propertiesFilePath = System.getProperty("user.home") + "/.aws/awsTestAccount.properties";
        chain = new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new PropertiesFileCredentialsProvider(propertiesFilePath), new ProfileCredentialsProvider(TEST_CREDENTIALS_PROFILE_NAME), new EnvironmentVariableCredentialsProvider(), new SystemPropertiesCredentialsProvider()});
    }
}

