/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.taxsettings;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.taxsettings.AWSTaxSettingsAsync;
import com.amazonaws.services.taxsettings.AWSTaxSettingsAsyncClientBuilder;
import com.amazonaws.services.taxsettings.AWSTaxSettingsClient;
import com.amazonaws.services.taxsettings.model.BatchDeleteTaxRegistrationRequest;
import com.amazonaws.services.taxsettings.model.BatchDeleteTaxRegistrationResult;
import com.amazonaws.services.taxsettings.model.BatchPutTaxRegistrationRequest;
import com.amazonaws.services.taxsettings.model.BatchPutTaxRegistrationResult;
import com.amazonaws.services.taxsettings.model.DeleteTaxRegistrationRequest;
import com.amazonaws.services.taxsettings.model.DeleteTaxRegistrationResult;
import com.amazonaws.services.taxsettings.model.GetTaxRegistrationDocumentRequest;
import com.amazonaws.services.taxsettings.model.GetTaxRegistrationDocumentResult;
import com.amazonaws.services.taxsettings.model.GetTaxRegistrationRequest;
import com.amazonaws.services.taxsettings.model.GetTaxRegistrationResult;
import com.amazonaws.services.taxsettings.model.ListTaxRegistrationsRequest;
import com.amazonaws.services.taxsettings.model.ListTaxRegistrationsResult;
import com.amazonaws.services.taxsettings.model.PutTaxRegistrationRequest;
import com.amazonaws.services.taxsettings.model.PutTaxRegistrationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSTaxSettingsAsyncClient
extends AWSTaxSettingsClient
implements AWSTaxSettingsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSTaxSettingsAsyncClientBuilder asyncBuilder() {
        return AWSTaxSettingsAsyncClientBuilder.standard();
    }

    AWSTaxSettingsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSTaxSettingsAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchDeleteTaxRegistrationResult> batchDeleteTaxRegistrationAsync(BatchDeleteTaxRegistrationRequest request) {
        return this.batchDeleteTaxRegistrationAsync(request, null);
    }

    @Override
    public Future<BatchDeleteTaxRegistrationResult> batchDeleteTaxRegistrationAsync(BatchDeleteTaxRegistrationRequest request, final AsyncHandler<BatchDeleteTaxRegistrationRequest, BatchDeleteTaxRegistrationResult> asyncHandler) {
        final BatchDeleteTaxRegistrationRequest finalRequest = (BatchDeleteTaxRegistrationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchDeleteTaxRegistrationResult>(){

            @Override
            public BatchDeleteTaxRegistrationResult call() throws Exception {
                BatchDeleteTaxRegistrationResult result = null;
                try {
                    result = AWSTaxSettingsAsyncClient.this.executeBatchDeleteTaxRegistration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchPutTaxRegistrationResult> batchPutTaxRegistrationAsync(BatchPutTaxRegistrationRequest request) {
        return this.batchPutTaxRegistrationAsync(request, null);
    }

    @Override
    public Future<BatchPutTaxRegistrationResult> batchPutTaxRegistrationAsync(BatchPutTaxRegistrationRequest request, final AsyncHandler<BatchPutTaxRegistrationRequest, BatchPutTaxRegistrationResult> asyncHandler) {
        final BatchPutTaxRegistrationRequest finalRequest = (BatchPutTaxRegistrationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchPutTaxRegistrationResult>(){

            @Override
            public BatchPutTaxRegistrationResult call() throws Exception {
                BatchPutTaxRegistrationResult result = null;
                try {
                    result = AWSTaxSettingsAsyncClient.this.executeBatchPutTaxRegistration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTaxRegistrationResult> deleteTaxRegistrationAsync(DeleteTaxRegistrationRequest request) {
        return this.deleteTaxRegistrationAsync(request, null);
    }

    @Override
    public Future<DeleteTaxRegistrationResult> deleteTaxRegistrationAsync(DeleteTaxRegistrationRequest request, final AsyncHandler<DeleteTaxRegistrationRequest, DeleteTaxRegistrationResult> asyncHandler) {
        final DeleteTaxRegistrationRequest finalRequest = (DeleteTaxRegistrationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteTaxRegistrationResult>(){

            @Override
            public DeleteTaxRegistrationResult call() throws Exception {
                DeleteTaxRegistrationResult result = null;
                try {
                    result = AWSTaxSettingsAsyncClient.this.executeDeleteTaxRegistration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTaxRegistrationResult> getTaxRegistrationAsync(GetTaxRegistrationRequest request) {
        return this.getTaxRegistrationAsync(request, null);
    }

    @Override
    public Future<GetTaxRegistrationResult> getTaxRegistrationAsync(GetTaxRegistrationRequest request, final AsyncHandler<GetTaxRegistrationRequest, GetTaxRegistrationResult> asyncHandler) {
        final GetTaxRegistrationRequest finalRequest = (GetTaxRegistrationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTaxRegistrationResult>(){

            @Override
            public GetTaxRegistrationResult call() throws Exception {
                GetTaxRegistrationResult result = null;
                try {
                    result = AWSTaxSettingsAsyncClient.this.executeGetTaxRegistration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTaxRegistrationDocumentResult> getTaxRegistrationDocumentAsync(GetTaxRegistrationDocumentRequest request) {
        return this.getTaxRegistrationDocumentAsync(request, null);
    }

    @Override
    public Future<GetTaxRegistrationDocumentResult> getTaxRegistrationDocumentAsync(GetTaxRegistrationDocumentRequest request, final AsyncHandler<GetTaxRegistrationDocumentRequest, GetTaxRegistrationDocumentResult> asyncHandler) {
        final GetTaxRegistrationDocumentRequest finalRequest = (GetTaxRegistrationDocumentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTaxRegistrationDocumentResult>(){

            @Override
            public GetTaxRegistrationDocumentResult call() throws Exception {
                GetTaxRegistrationDocumentResult result = null;
                try {
                    result = AWSTaxSettingsAsyncClient.this.executeGetTaxRegistrationDocument(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTaxRegistrationsResult> listTaxRegistrationsAsync(ListTaxRegistrationsRequest request) {
        return this.listTaxRegistrationsAsync(request, null);
    }

    @Override
    public Future<ListTaxRegistrationsResult> listTaxRegistrationsAsync(ListTaxRegistrationsRequest request, final AsyncHandler<ListTaxRegistrationsRequest, ListTaxRegistrationsResult> asyncHandler) {
        final ListTaxRegistrationsRequest finalRequest = (ListTaxRegistrationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTaxRegistrationsResult>(){

            @Override
            public ListTaxRegistrationsResult call() throws Exception {
                ListTaxRegistrationsResult result = null;
                try {
                    result = AWSTaxSettingsAsyncClient.this.executeListTaxRegistrations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutTaxRegistrationResult> putTaxRegistrationAsync(PutTaxRegistrationRequest request) {
        return this.putTaxRegistrationAsync(request, null);
    }

    @Override
    public Future<PutTaxRegistrationResult> putTaxRegistrationAsync(PutTaxRegistrationRequest request, final AsyncHandler<PutTaxRegistrationRequest, PutTaxRegistrationResult> asyncHandler) {
        final PutTaxRegistrationRequest finalRequest = (PutTaxRegistrationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutTaxRegistrationResult>(){

            @Override
            public PutTaxRegistrationResult call() throws Exception {
                PutTaxRegistrationResult result = null;
                try {
                    result = AWSTaxSettingsAsyncClient.this.executePutTaxRegistration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

