/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.synthetics.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.synthetics.model.BaseScreenshot;
import com.amazonaws.services.synthetics.model.transform.VisualReferenceInputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class VisualReferenceInput
implements Serializable,
Cloneable,
StructuredPojo {
    private List<BaseScreenshot> baseScreenshots;
    private String baseCanaryRunId;

    public List<BaseScreenshot> getBaseScreenshots() {
        return this.baseScreenshots;
    }

    public void setBaseScreenshots(Collection<BaseScreenshot> baseScreenshots) {
        if (baseScreenshots == null) {
            this.baseScreenshots = null;
            return;
        }
        this.baseScreenshots = new ArrayList<BaseScreenshot>(baseScreenshots);
    }

    public VisualReferenceInput withBaseScreenshots(BaseScreenshot ... baseScreenshots) {
        if (this.baseScreenshots == null) {
            this.setBaseScreenshots(new ArrayList<BaseScreenshot>(baseScreenshots.length));
        }
        for (BaseScreenshot ele : baseScreenshots) {
            this.baseScreenshots.add(ele);
        }
        return this;
    }

    public VisualReferenceInput withBaseScreenshots(Collection<BaseScreenshot> baseScreenshots) {
        this.setBaseScreenshots(baseScreenshots);
        return this;
    }

    public void setBaseCanaryRunId(String baseCanaryRunId) {
        this.baseCanaryRunId = baseCanaryRunId;
    }

    public String getBaseCanaryRunId() {
        return this.baseCanaryRunId;
    }

    public VisualReferenceInput withBaseCanaryRunId(String baseCanaryRunId) {
        this.setBaseCanaryRunId(baseCanaryRunId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBaseScreenshots() != null) {
            sb.append("BaseScreenshots: ").append(this.getBaseScreenshots()).append(",");
        }
        if (this.getBaseCanaryRunId() != null) {
            sb.append("BaseCanaryRunId: ").append(this.getBaseCanaryRunId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VisualReferenceInput)) {
            return false;
        }
        VisualReferenceInput other = (VisualReferenceInput)obj;
        if (other.getBaseScreenshots() == null ^ this.getBaseScreenshots() == null) {
            return false;
        }
        if (other.getBaseScreenshots() != null && !other.getBaseScreenshots().equals(this.getBaseScreenshots())) {
            return false;
        }
        if (other.getBaseCanaryRunId() == null ^ this.getBaseCanaryRunId() == null) {
            return false;
        }
        return other.getBaseCanaryRunId() == null || other.getBaseCanaryRunId().equals(this.getBaseCanaryRunId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBaseScreenshots() == null ? 0 : this.getBaseScreenshots().hashCode());
        hashCode = 31 * hashCode + (this.getBaseCanaryRunId() == null ? 0 : this.getBaseCanaryRunId().hashCode());
        return hashCode;
    }

    public VisualReferenceInput clone() {
        try {
            return (VisualReferenceInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VisualReferenceInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

