/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.worker.DecisionId;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionState;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionStateMachineBase;
import software.amazon.awssdk.services.swf.model.CancelTimerDecisionAttributes;
import software.amazon.awssdk.services.swf.model.Decision;
import software.amazon.awssdk.services.swf.model.DecisionType;
import software.amazon.awssdk.services.swf.model.HistoryEvent;
import software.amazon.awssdk.services.swf.model.StartTimerDecisionAttributes;

class TimerDecisionStateMachine
extends DecisionStateMachineBase {
    private StartTimerDecisionAttributes attributes;
    private boolean canceled;

    public TimerDecisionStateMachine(DecisionId id, StartTimerDecisionAttributes attributes) {
        super(id);
        this.attributes = attributes;
    }

    TimerDecisionStateMachine(DecisionId id, StartTimerDecisionAttributes attributes, DecisionState state) {
        super(id, state);
        this.attributes = attributes;
    }

    @Override
    public Decision getDecision() {
        switch (this.state) {
            case CREATED: {
                return this.createStartTimerDecision();
            }
            case CANCELED_AFTER_INITIATED: {
                return this.createCancelTimerDecision();
            }
        }
        return null;
    }

    @Override
    public void handleDecisionTaskStartedEvent() {
        switch (this.state) {
            case CANCELED_AFTER_INITIATED: {
                this.stateHistory.add("handleDecisionTaskStartedEvent");
                this.state = DecisionState.CANCELLATION_DECISION_SENT;
                this.stateHistory.add(this.state.toString());
                break;
            }
            default: {
                super.handleDecisionTaskStartedEvent();
            }
        }
    }

    @Override
    public void handleCancellationFailureEvent(HistoryEvent event) {
        switch (this.state) {
            case CANCELLATION_DECISION_SENT: {
                this.stateHistory.add("handleCancellationFailureEvent");
                this.state = DecisionState.INITIATED;
                this.stateHistory.add(this.state.toString());
                break;
            }
            default: {
                super.handleCancellationFailureEvent(event);
            }
        }
    }

    @Override
    public void cancel(Runnable immediateCancellationCallback) {
        this.canceled = true;
        immediateCancellationCallback.run();
        super.cancel(null);
    }

    @Override
    public boolean isDone() {
        return this.state == DecisionState.COMPLETED || this.canceled;
    }

    private Decision createCancelTimerDecision() {
        CancelTimerDecisionAttributes tryCancel = (CancelTimerDecisionAttributes)CancelTimerDecisionAttributes.builder().timerId(this.attributes.timerId()).build();
        return (Decision)Decision.builder().cancelTimerDecisionAttributes(tryCancel).decisionType(DecisionType.CANCEL_TIMER).build();
    }

    private Decision createStartTimerDecision() {
        return (Decision)Decision.builder().startTimerDecisionAttributes(this.attributes).decisionType(DecisionType.START_TIMER).build();
    }
}

