/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.common.WorkflowExecutionUtils;
import com.amazonaws.services.simpleworkflow.flow.monitoring.MetricName;
import com.amazonaws.services.simpleworkflow.flow.monitoring.ThreadLocalMetrics;
import com.amazonaws.services.simpleworkflow.flow.worker.ComponentVersions;
import com.amazonaws.services.simpleworkflow.flow.worker.IncompatibleWorkflowDefinition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.services.swf.model.DecisionTaskTimeoutType;
import software.amazon.awssdk.services.swf.model.EventType;
import software.amazon.awssdk.services.swf.model.HistoryEvent;
import software.amazon.awssdk.services.swf.model.PollForDecisionTaskResponse;

public class HistoryHelper {
    private static final Log historyLog = LogFactory.getLog((String)(HistoryHelper.class.getName() + ".history"));
    private final SingleDecisionEventsIterator singleDecisionEventsIterator;
    private SingleDecisionData currentDecisionData;

    void setComponentVersions(ComponentVersions componentVersions) {
        this.singleDecisionEventsIterator.componentVersions = componentVersions;
    }

    void setWorkflowContextData(String workflowContextData) {
        this.singleDecisionEventsIterator.workflowContextData = workflowContextData;
    }

    void clearHistoryEvents() {
        this.singleDecisionEventsIterator.events.clearDecisionTasksAndHistoryEvents();
        this.singleDecisionEventsIterator.current = null;
        this.singleDecisionEventsIterator.next = null;
    }

    public HistoryHelper(Iterator<PollForDecisionTaskResponse> decisionTasks) {
        this.singleDecisionEventsIterator = new SingleDecisionEventsIterator(decisionTasks);
    }

    public List<HistoryEvent> getSingleDecisionEvents() {
        if (!this.singleDecisionEventsIterator.hasNext()) {
            this.currentDecisionData = null;
            return null;
        }
        this.currentDecisionData = this.singleDecisionEventsIterator.next();
        return this.currentDecisionData.getDecisionEvents();
    }

    public PollForDecisionTaskResponse getDecisionTask() {
        return this.singleDecisionEventsIterator.getDecisionTask();
    }

    public String getWorkflowContextData() {
        if (this.currentDecisionData == null) {
            throw new IllegalStateException();
        }
        return this.currentDecisionData.getWorkflowContextData();
    }

    public long getReplayCurrentTimeMilliseconds() {
        if (this.currentDecisionData == null) {
            throw new IllegalStateException();
        }
        return this.currentDecisionData.getReplayCurrentTimeMilliseconds();
    }

    public ComponentVersions getComponentVersions() {
        return this.singleDecisionEventsIterator.getComponentVersions();
    }

    public long getLastNonReplayEventId() {
        Long result = this.getDecisionTask().previousStartedEventId();
        if (result == null) {
            return 0L;
        }
        return result;
    }

    class EventsIterator
    implements Iterator<HistoryEvent> {
        private final FailureTracker failureTracker = new FailureTracker();
        private Iterator<PollForDecisionTaskResponse> decisionTasks;
        private PollForDecisionTaskResponse decisionTask;
        private List<HistoryEvent> events;
        private int index;

        public EventsIterator(Iterator<PollForDecisionTaskResponse> decisionTasks) {
            this.decisionTasks = decisionTasks;
            if (decisionTasks.hasNext()) {
                this.decisionTask = decisionTasks.next();
                this.events = this.decisionTask.events();
                if (historyLog.isTraceEnabled()) {
                    historyLog.trace((Object)WorkflowExecutionUtils.prettyPrintHistory(this.events, true));
                }
            } else {
                this.decisionTask = null;
            }
        }

        @Override
        public boolean hasNext() {
            boolean hasNext;
            boolean bl = hasNext = this.decisionTask != null && (this.index < this.events.size() || this.decisionTasks.hasNext());
            if (!hasNext) {
                this.failureTracker.recordMetric();
            }
            return hasNext;
        }

        @Override
        public HistoryEvent next() {
            if (this.index == this.events.size()) {
                this.decisionTask = this.decisionTasks.next();
                this.events = this.decisionTask.events();
                if (historyLog.isTraceEnabled()) {
                    historyLog.trace((Object)WorkflowExecutionUtils.prettyPrintHistory(this.events, true));
                }
                this.index = 0;
            }
            HistoryEvent historyEvent = this.events.get(this.index++);
            this.failureTracker.processEvent(historyEvent);
            return historyEvent;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        void clearDecisionTasksAndHistoryEvents() {
            this.decisionTasks = null;
            this.events = null;
            this.decisionTask = (PollForDecisionTaskResponse)this.decisionTask.toBuilder().events(new HistoryEvent[]{null}).build();
        }

        public PollForDecisionTaskResponse getDecisionTask() {
            return this.decisionTask;
        }

        public List<HistoryEvent> getEvents() {
            return this.events;
        }

        private class FailureTracker {
            private int successiveDecisionFailureCount = 0;
            private boolean metricAlreadyRecorded = false;

            private FailureTracker() {
            }

            public void processEvent(HistoryEvent historyEvent) {
                switch (EventType.fromValue((String)historyEvent.eventTypeAsString())) {
                    case DECISION_TASK_COMPLETED: {
                        this.resetCount();
                        break;
                    }
                    case DECISION_TASK_TIMED_OUT: {
                        ++this.successiveDecisionFailureCount;
                        break;
                    }
                }
            }

            public int getFailureCount() {
                return this.successiveDecisionFailureCount;
            }

            public void recordMetric() {
                if (!this.metricAlreadyRecorded) {
                    ThreadLocalMetrics.getMetrics().recordCount(MetricName.SUCCESSIVE_DECISION_FAILURE.getName(), EventsIterator.this.failureTracker.getFailureCount());
                    this.metricAlreadyRecorded = true;
                }
            }

            private void resetCount() {
                this.successiveDecisionFailureCount = 0;
            }
        }
    }

    class SingleDecisionEventsIterator
    implements Iterator<SingleDecisionData> {
        private EventsIterator events;
        private ComponentVersions componentVersions = new ComponentVersions();
        private String workflowContextData;
        private SingleDecisionData current;
        private SingleDecisionData next;

        public SingleDecisionEventsIterator(Iterator<PollForDecisionTaskResponse> decisionTasks) {
            this.events = new EventsIterator(decisionTasks);
            this.fillNext();
            this.current = this.next;
            this.fillNext();
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public SingleDecisionData next() {
            SingleDecisionData result = this.current;
            this.current = this.next;
            this.fillNext();
            return result;
        }

        private void fillNext() {
            boolean decisionTaskTimedOut = false;
            ArrayList<Object> decisionStartToCompletionEvents = new ArrayList<HistoryEvent>();
            ArrayList<HistoryEvent> decisionCompletionToStartEvents = new ArrayList<HistoryEvent>();
            boolean concurrentToDecision = true;
            int lastDecisionIndex = -1;
            long nextReplayCurrentTimeMilliseconds = -1L;
            while (this.events.hasNext()) {
                HistoryEvent event = this.events.next();
                EventType eventType = EventType.fromValue((String)event.eventTypeAsString());
                if (eventType == EventType.DECISION_TASK_COMPLETED) {
                    String executionContext = event.decisionTaskCompletedEventAttributes().executionContext();
                    this.updateWorkflowContextDataAndComponentVersions(executionContext);
                    concurrentToDecision = false;
                    continue;
                }
                if (eventType == EventType.DECISION_TASK_STARTED) {
                    nextReplayCurrentTimeMilliseconds = event.eventTimestamp().toEpochMilli();
                    if (!decisionTaskTimedOut) break;
                    this.current.getDecisionEvents().addAll(decisionStartToCompletionEvents);
                    decisionStartToCompletionEvents = new ArrayList();
                    decisionTaskTimedOut = false;
                    continue;
                }
                if (eventType.equals((Object)EventType.DECISION_TASK_TIMED_OUT)) {
                    DecisionTaskTimeoutType timeoutType = DecisionTaskTimeoutType.valueOf((String)event.decisionTaskTimedOutEventAttributes().timeoutTypeAsString());
                    if (timeoutType != DecisionTaskTimeoutType.START_TO_CLOSE) continue;
                    decisionTaskTimedOut = true;
                    continue;
                }
                if (eventType == EventType.DECISION_TASK_SCHEDULED || eventType == EventType.MARKER_RECORDED || eventType == EventType.RECORD_MARKER_FAILED) continue;
                if (concurrentToDecision) {
                    decisionStartToCompletionEvents.add(event);
                    continue;
                }
                if (this.isDecisionEvent(eventType)) {
                    lastDecisionIndex = decisionCompletionToStartEvents.size();
                }
                decisionCompletionToStartEvents.add(event);
            }
            List<HistoryEvent> nextEvents = this.reorderEvents(decisionStartToCompletionEvents, decisionCompletionToStartEvents, lastDecisionIndex);
            this.next = new SingleDecisionData(nextEvents, nextReplayCurrentTimeMilliseconds, this.workflowContextData);
        }

        public PollForDecisionTaskResponse getDecisionTask() {
            return this.events.getDecisionTask();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private boolean isDecisionEvent(EventType eventType) {
            switch (eventType) {
                case ACTIVITY_TASK_SCHEDULED: 
                case SCHEDULE_ACTIVITY_TASK_FAILED: 
                case ACTIVITY_TASK_CANCEL_REQUESTED: 
                case REQUEST_CANCEL_ACTIVITY_TASK_FAILED: 
                case MARKER_RECORDED: 
                case RECORD_MARKER_FAILED: 
                case WORKFLOW_EXECUTION_COMPLETED: 
                case COMPLETE_WORKFLOW_EXECUTION_FAILED: 
                case WORKFLOW_EXECUTION_FAILED: 
                case FAIL_WORKFLOW_EXECUTION_FAILED: 
                case WORKFLOW_EXECUTION_CANCELED: 
                case CANCEL_WORKFLOW_EXECUTION_FAILED: 
                case WORKFLOW_EXECUTION_CONTINUED_AS_NEW: 
                case CONTINUE_AS_NEW_WORKFLOW_EXECUTION_FAILED: 
                case TIMER_STARTED: 
                case START_TIMER_FAILED: 
                case TIMER_CANCELED: 
                case CANCEL_TIMER_FAILED: 
                case SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED: 
                case SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_FAILED: 
                case REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED: 
                case REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_FAILED: 
                case START_CHILD_WORKFLOW_EXECUTION_INITIATED: 
                case START_CHILD_WORKFLOW_EXECUTION_FAILED: {
                    return true;
                }
            }
            return false;
        }

        private List<HistoryEvent> reorderEvents(List<HistoryEvent> decisionStartToCompletionEvents, List<HistoryEvent> decisionCompletionToStartEvents, int lastDecisionIndex) {
            int size = decisionStartToCompletionEvents.size() + decisionCompletionToStartEvents.size();
            ArrayList<HistoryEvent> reordered = new ArrayList<HistoryEvent>(size);
            if (lastDecisionIndex >= 0) {
                reordered.addAll(decisionCompletionToStartEvents.subList(0, lastDecisionIndex + 1));
            }
            reordered.addAll(decisionStartToCompletionEvents);
            if (decisionCompletionToStartEvents.size() > lastDecisionIndex + 1) {
                reordered.addAll(decisionCompletionToStartEvents.subList(lastDecisionIndex + 1, decisionCompletionToStartEvents.size()));
            }
            return reordered;
        }

        private void updateWorkflowContextDataAndComponentVersions(String executionContext) {
            if (executionContext != null && executionContext.startsWith("*component_version*")) {
                Scanner scanner = new Scanner(executionContext);
                scanner.useDelimiter("\n|\t");
                scanner.next();
                int size = scanner.nextInt();
                for (int i = 0; i < size; ++i) {
                    String componentName = scanner.next();
                    int version = scanner.nextInt();
                    if (componentName == null) {
                        throw new IncompatibleWorkflowDefinition("null component name in line " + i + " in the execution context: " + executionContext);
                    }
                    this.componentVersions.setVersionFromHistory(componentName, version);
                }
                this.workflowContextData = scanner.next(".*");
            } else {
                this.workflowContextData = executionContext;
            }
        }

        public ComponentVersions getComponentVersions() {
            return this.componentVersions;
        }
    }

    private class SingleDecisionData {
        private final List<HistoryEvent> decisionEvents;
        private final long replayCurrentTimeMilliseconds;
        private final String workflowContextData;

        public SingleDecisionData(List<HistoryEvent> decisionEvents, long replayCurrentTimeMilliseconds, String workflowContextData) {
            this.decisionEvents = decisionEvents;
            this.replayCurrentTimeMilliseconds = replayCurrentTimeMilliseconds;
            this.workflowContextData = workflowContextData;
        }

        public List<HistoryEvent> getDecisionEvents() {
            return this.decisionEvents;
        }

        public long getReplayCurrentTimeMilliseconds() {
            return this.replayCurrentTimeMilliseconds;
        }

        public String getWorkflowContextData() {
            return this.workflowContextData;
        }
    }
}

