/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.ChildWorkflowIdHandler;
import com.amazonaws.services.simpleworkflow.flow.DefaultChildWorkflowIdHandler;
import com.amazonaws.services.simpleworkflow.flow.WorkflowTypeRegistrationOptions;
import com.amazonaws.services.simpleworkflow.flow.common.FlowHelpers;
import com.amazonaws.services.simpleworkflow.flow.common.RequestTimeoutHelper;
import com.amazonaws.services.simpleworkflow.flow.config.SimpleWorkflowClientConfig;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactory;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactoryFactory;
import com.amazonaws.services.simpleworkflow.flow.model.WorkflowType;
import com.amazonaws.services.simpleworkflow.flow.monitoring.MetricName;
import com.amazonaws.services.simpleworkflow.flow.monitoring.ThreadLocalMetrics;
import com.amazonaws.services.simpleworkflow.flow.retry.ThrottlingRetrier;
import com.amazonaws.services.simpleworkflow.flow.worker.AffinityHelper;
import com.amazonaws.services.simpleworkflow.flow.worker.AsyncDecisionTaskHandler;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionTaskPoller;
import com.amazonaws.services.simpleworkflow.flow.worker.GenericWorker;
import com.amazonaws.services.simpleworkflow.flow.worker.TaskPoller;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.services.swf.SwfClient;
import software.amazon.awssdk.services.swf.model.RegisterWorkflowTypeRequest;
import software.amazon.awssdk.services.swf.model.TaskList;
import software.amazon.awssdk.services.swf.model.TypeAlreadyExistsException;

public class GenericWorkflowWorker
extends GenericWorker<DecisionTaskPoller.DecisionTaskIterator> {
    private static final Log log = LogFactory.getLog(GenericWorkflowWorker.class);
    public static final String THREAD_NAME_PREFIX = "SWF Decider ";
    protected WorkflowDefinitionFactoryFactory workflowDefinitionFactoryFactory;
    protected ChildWorkflowIdHandler childWorkflowIdHandler = new DefaultChildWorkflowIdHandler();

    public GenericWorkflowWorker() {
    }

    public GenericWorkflowWorker(SwfClient service, String domain, String taskListToPoll) {
        super(service, domain, taskListToPoll, null);
    }

    public GenericWorkflowWorker(SwfClient service, String domain, String taskListToPoll, SimpleWorkflowClientConfig config) {
        super(service, domain, taskListToPoll, config);
    }

    GenericWorkflowWorker(SwfClient service, String domain, String taskListToPoll, ScheduledExecutorService pollerExecutor, ThreadPoolExecutor workerExecutor, DecisionTaskPoller decisionTaskPoller, Boolean startRequested) {
        super(service, domain, taskListToPoll, pollerExecutor, workerExecutor, decisionTaskPoller, startRequested);
    }

    @Override
    protected TaskPoller<DecisionTaskPoller.DecisionTaskIterator> createPoller() {
        DecisionTaskPoller result = new DecisionTaskPoller();
        SimpleWorkflowClientConfig config = this.getClientConfig() == null ? SimpleWorkflowClientConfig.ofDefaults() : this.getClientConfig();
        AffinityHelper affinityHelper = new AffinityHelper(this.getService(), this.getDomain(), this.getClientConfig(), false);
        result.setDecisionTaskHandler(new AsyncDecisionTaskHandler(this.workflowDefinitionFactoryFactory, this.childWorkflowIdHandler, affinityHelper, config));
        result.setDomain(this.getDomain());
        result.setIdentity(this.getIdentity());
        result.setService(this.getService());
        result.setTaskListToPoll(this.getTaskListToPoll());
        result.setMetricsRegistry(this.getMetricsRegistry());
        result.setConfig(this.getClientConfig());
        return result;
    }

    @Override
    public void registerTypesToPoll() {
        GenericWorkflowWorker.registerWorkflowTypes(this.service, this.domain, this.getTaskListToPoll(), this.workflowDefinitionFactoryFactory);
    }

    public static void registerWorkflowTypes(SwfClient service, String domain, String defaultTaskList, WorkflowDefinitionFactoryFactory workflowDefinitionFactoryFactory) {
        GenericWorkflowWorker.registerWorkflowTypes(service, domain, defaultTaskList, workflowDefinitionFactoryFactory, null);
    }

    public static void registerWorkflowTypes(SwfClient service, String domain, String defaultTaskList, WorkflowDefinitionFactoryFactory workflowDefinitionFactoryFactory, SimpleWorkflowClientConfig config) {
        for (WorkflowType typeToRegister : workflowDefinitionFactoryFactory.getWorkflowTypesToRegister()) {
            WorkflowDefinitionFactory workflowDefinitionFactory = workflowDefinitionFactoryFactory.getWorkflowDefinitionFactory(typeToRegister);
            WorkflowTypeRegistrationOptions registrationOptions = workflowDefinitionFactory.getWorkflowRegistrationOptions();
            if (registrationOptions == null) continue;
            WorkflowType workflowType = workflowDefinitionFactory.getWorkflowType();
            try {
                GenericWorkflowWorker.registerWorkflowType(service, domain, workflowType, registrationOptions, defaultTaskList, config);
            }
            catch (TypeAlreadyExistsException ex) {
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Workflow Type already registered: " + workflowType));
            }
        }
    }

    public static void registerWorkflowType(SwfClient service, String domain, WorkflowType workflowType, WorkflowTypeRegistrationOptions registrationOptions, String defaultTaskList) {
        GenericWorkflowWorker.registerWorkflowType(service, domain, workflowType, registrationOptions, defaultTaskList, null);
    }

    public static void registerWorkflowType(SwfClient service, String domain, WorkflowType workflowType, WorkflowTypeRegistrationOptions registrationOptions, String defaultTaskList, SimpleWorkflowClientConfig config) {
        RegisterWorkflowTypeRequest registerWorkflow = GenericWorkflowWorker.buildRegisterWorkflowTypeRequest(domain, workflowType, registrationOptions, defaultTaskList);
        registerWorkflow = RequestTimeoutHelper.overrideControlPlaneRequestTimeout(registerWorkflow, config);
        GenericWorkflowWorker.registerWorkflowTypeWithRetry(service, registerWorkflow);
    }

    private static RegisterWorkflowTypeRequest buildRegisterWorkflowTypeRequest(String domain, WorkflowType workflowType, WorkflowTypeRegistrationOptions registrationOptions, String defaultTaskList) {
        RegisterWorkflowTypeRequest.Builder registerWorkflowBuilder = RegisterWorkflowTypeRequest.builder().domain(domain).name(workflowType.getName()).version(workflowType.getVersion());
        String taskList = registrationOptions.getDefaultTaskList();
        if (taskList == null) {
            taskList = defaultTaskList;
        } else if (taskList.equals("NO_DEFAULT_TASK_LIST")) {
            taskList = null;
        }
        if (taskList != null && !taskList.isEmpty()) {
            registerWorkflowBuilder.defaultTaskList((TaskList)TaskList.builder().name(taskList).build());
        }
        registerWorkflowBuilder.defaultChildPolicy(registrationOptions.getDefaultChildPolicy().toString()).defaultTaskStartToCloseTimeout(FlowHelpers.secondsToDuration(registrationOptions.getDefaultTaskStartToCloseTimeoutSeconds())).defaultExecutionStartToCloseTimeout(FlowHelpers.secondsToDuration(registrationOptions.getDefaultExecutionStartToCloseTimeoutSeconds())).defaultTaskPriority(FlowHelpers.taskPriorityToString(registrationOptions.getDefaultTaskPriority())).defaultLambdaRole(registrationOptions.getDefaultLambdaRole());
        String description = registrationOptions.getDescription();
        if (description != null) {
            registerWorkflowBuilder.description(description);
        }
        return (RegisterWorkflowTypeRequest)registerWorkflowBuilder.build();
    }

    private static void registerWorkflowTypeWithRetry(SwfClient service, RegisterWorkflowTypeRequest registerWorkflowTypeRequest) {
        ThrottlingRetrier retrier = new ThrottlingRetrier(GenericWorkflowWorker.getRegisterTypeThrottledRetryParameters());
        retrier.retry(() -> ThreadLocalMetrics.getMetrics().recordRunnable(() -> service.registerWorkflowType(registerWorkflowTypeRequest), MetricName.Operation.REGISTER_WORKFLOW_TYPE.getName(), TimeUnit.MILLISECONDS));
    }

    @Override
    protected void checkRequiredProperties() {
        this.checkRequiredProperty(this.workflowDefinitionFactoryFactory, "workflowDefinitionFactoryFactory");
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[super=" + super.toString() + ", workflowDefinitionFactoryFactory=" + this.workflowDefinitionFactoryFactory + "]";
    }

    @Override
    protected String getPollThreadNamePrefix() {
        return THREAD_NAME_PREFIX + this.getTaskListToPoll();
    }

    @Override
    protected GenericWorker.WorkerType getWorkerType() {
        return GenericWorker.WorkerType.WORKFLOW;
    }

    public WorkflowDefinitionFactoryFactory getWorkflowDefinitionFactoryFactory() {
        return this.workflowDefinitionFactoryFactory;
    }

    public void setWorkflowDefinitionFactoryFactory(WorkflowDefinitionFactoryFactory workflowDefinitionFactoryFactory) {
        this.workflowDefinitionFactoryFactory = workflowDefinitionFactoryFactory;
    }

    public void setChildWorkflowIdHandler(ChildWorkflowIdHandler childWorkflowIdHandler) {
        this.childWorkflowIdHandler = childWorkflowIdHandler;
    }
}

