/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.ChildWorkflowFailedException;
import com.amazonaws.services.simpleworkflow.flow.ChildWorkflowTerminatedException;
import com.amazonaws.services.simpleworkflow.flow.ChildWorkflowTimedOutException;
import com.amazonaws.services.simpleworkflow.flow.SignalExternalWorkflowException;
import com.amazonaws.services.simpleworkflow.flow.StartChildWorkflowFailedException;
import com.amazonaws.services.simpleworkflow.flow.WorkflowContext;
import com.amazonaws.services.simpleworkflow.flow.common.FlowHelpers;
import com.amazonaws.services.simpleworkflow.flow.core.ExternalTask;
import com.amazonaws.services.simpleworkflow.flow.core.ExternalTaskCancellationHandler;
import com.amazonaws.services.simpleworkflow.flow.core.ExternalTaskCompletionHandle;
import com.amazonaws.services.simpleworkflow.flow.core.Functor;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.amazonaws.services.simpleworkflow.flow.core.Task;
import com.amazonaws.services.simpleworkflow.flow.generic.ContinueAsNewWorkflowExecutionParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.GenericWorkflowClient;
import com.amazonaws.services.simpleworkflow.flow.generic.SignalExternalWorkflowParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.StartChildWorkflowExecutionParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.StartChildWorkflowReply;
import com.amazonaws.services.simpleworkflow.flow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.flow.model.WorkflowType;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionsHelper;
import com.amazonaws.services.simpleworkflow.flow.worker.OpenRequestInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import software.amazon.awssdk.services.swf.model.ChildPolicy;
import software.amazon.awssdk.services.swf.model.ChildWorkflowExecutionCanceledEventAttributes;
import software.amazon.awssdk.services.swf.model.ChildWorkflowExecutionCompletedEventAttributes;
import software.amazon.awssdk.services.swf.model.ChildWorkflowExecutionFailedEventAttributes;
import software.amazon.awssdk.services.swf.model.ChildWorkflowExecutionStartedEventAttributes;
import software.amazon.awssdk.services.swf.model.ChildWorkflowExecutionTerminatedEventAttributes;
import software.amazon.awssdk.services.swf.model.ChildWorkflowExecutionTimedOutEventAttributes;
import software.amazon.awssdk.services.swf.model.ExternalWorkflowExecutionSignaledEventAttributes;
import software.amazon.awssdk.services.swf.model.HistoryEvent;
import software.amazon.awssdk.services.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes;
import software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionDecisionAttributes;
import software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes;
import software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionDecisionAttributes;
import software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionFailedCause;
import software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionFailedEventAttributes;
import software.amazon.awssdk.services.swf.model.TaskList;

class GenericWorkflowClientImpl
implements GenericWorkflowClient {
    private final DecisionsHelper decisions;
    private final WorkflowContext workflowContext;
    private final Map<String, OpenRequestInfo<StartChildWorkflowReply, WorkflowType>> scheduledExternalWorkflows = new HashMap<String, OpenRequestInfo<StartChildWorkflowReply, WorkflowType>>();
    private final Map<String, OpenRequestInfo<Void, Void>> scheduledSignals = new HashMap<String, OpenRequestInfo<Void, Void>>();

    GenericWorkflowClientImpl(DecisionsHelper decisions, WorkflowContext workflowContext) {
        this.decisions = decisions;
        this.workflowContext = workflowContext;
    }

    @Override
    public Promise<StartChildWorkflowReply> startChildWorkflow(StartChildWorkflowExecutionParameters parameters) {
        String taskList;
        ChildPolicy childPolicy;
        final OpenRequestInfo context = new OpenRequestInfo();
        String workflowId = parameters.getWorkflowId();
        if (workflowId == null) {
            workflowId = this.generateUniqueId();
        }
        StartChildWorkflowExecutionDecisionAttributes.Builder attributesBuilder = StartChildWorkflowExecutionDecisionAttributes.builder().workflowType(parameters.getWorkflowType().toSdkType()).workflowId(workflowId).input(parameters.getInput()).executionStartToCloseTimeout(FlowHelpers.secondsToDuration(parameters.getExecutionStartToCloseTimeoutSeconds())).taskStartToCloseTimeout(FlowHelpers.secondsToDuration(parameters.getTaskStartToCloseTimeoutSeconds())).taskPriority(FlowHelpers.taskPriorityToString(parameters.getTaskPriority())).lambdaRole(parameters.getLambdaRole());
        List<String> tagList = parameters.getTagList();
        if (tagList != null) {
            attributesBuilder.tagList(tagList);
        }
        if ((childPolicy = parameters.getChildPolicy()) != null) {
            attributesBuilder.childPolicy(childPolicy);
        }
        if ((taskList = parameters.getTaskList()) != null && !taskList.isEmpty()) {
            attributesBuilder.taskList((TaskList)TaskList.builder().name(taskList).build());
        }
        final StartChildWorkflowExecutionDecisionAttributes attributes = (StartChildWorkflowExecutionDecisionAttributes)attributesBuilder.build();
        String taskName = "workflowId=" + workflowId + ", workflowType=" + attributes.workflowId();
        new ExternalTask(new Promise[0]){

            @Override
            protected ExternalTaskCancellationHandler doExecute(ExternalTaskCompletionHandle handle) throws Throwable {
                context.setCompletionHandle(handle);
                String workflowId = attributes.workflowId();
                if (GenericWorkflowClientImpl.this.scheduledExternalWorkflows.containsKey(GenericWorkflowClientImpl.this.decisions.getActualChildWorkflowId(workflowId))) {
                    WorkflowExecution workflowExecution = WorkflowExecution.builder().workflowId(workflowId).build();
                    WorkflowType workflowType = WorkflowType.fromSdkType(attributes.workflowType());
                    long fakeEventId = -1L;
                    handle.fail(new StartChildWorkflowFailedException(fakeEventId, workflowExecution, workflowType, StartChildWorkflowExecutionFailedCause.WORKFLOW_ALREADY_RUNNING.toString()));
                    return new ChildWorkflowCancellationHandler(workflowId, handle);
                }
                GenericWorkflowClientImpl.this.decisions.startChildWorkflowExecution(attributes);
                GenericWorkflowClientImpl.this.scheduledExternalWorkflows.put(workflowId, context);
                return new ChildWorkflowCancellationHandler(workflowId, handle);
            }
        }.setName(taskName);
        context.setResultDescription("startChildWorkflow " + taskName);
        return context.getResult();
    }

    @Override
    public Promise<String> startChildWorkflow(String workflow, String version, String input) {
        StartChildWorkflowExecutionParameters parameters = new StartChildWorkflowExecutionParameters();
        parameters.setWorkflowType(WorkflowType.builder().name(workflow).version(version).build());
        parameters.setInput(input);
        final Promise<StartChildWorkflowReply> started = this.startChildWorkflow(parameters);
        return new Functor<String>(new Promise[]{started}){

            @Override
            protected Promise<String> doExecute() throws Throwable {
                return ((StartChildWorkflowReply)started.get()).getResult();
            }
        };
    }

    @Override
    public Promise<String> startChildWorkflow(final String workflow, final String version, final Promise<String> input) {
        final Settable<String> result = new Settable<String>();
        new Task(new Promise[]{input}){

            @Override
            protected void doExecute() throws Throwable {
                result.chain(GenericWorkflowClientImpl.this.startChildWorkflow(workflow, version, (String)input.get()));
            }
        };
        return result;
    }

    @Override
    public Promise<Void> signalWorkflowExecution(SignalExternalWorkflowParameters parameters) {
        final OpenRequestInfo context = new OpenRequestInfo();
        String signalId = this.decisions.getNextId();
        final SignalExternalWorkflowExecutionDecisionAttributes attributes = (SignalExternalWorkflowExecutionDecisionAttributes)SignalExternalWorkflowExecutionDecisionAttributes.builder().control(signalId).signalName(parameters.getSignalName()).input(parameters.getInput()).runId(parameters.getRunId()).workflowId(parameters.getWorkflowId()).build();
        String taskName = "signalId=" + signalId + ", workflowId=" + parameters.getWorkflowId() + ", workflowRunId=" + parameters.getRunId();
        new ExternalTask(new Promise[0]){

            @Override
            protected ExternalTaskCancellationHandler doExecute(final ExternalTaskCompletionHandle handle) throws Throwable {
                GenericWorkflowClientImpl.this.decisions.signalExternalWorkflowExecution(attributes);
                context.setCompletionHandle(handle);
                final String finalSignalId = attributes.control();
                GenericWorkflowClientImpl.this.scheduledSignals.put(finalSignalId, context);
                return new ExternalTaskCancellationHandler(){

                    @Override
                    public void handleCancellation(Throwable cause) {
                        GenericWorkflowClientImpl.this.decisions.cancelSignalExternalWorkflowExecution(finalSignalId, null);
                        OpenRequestInfo scheduled = (OpenRequestInfo)GenericWorkflowClientImpl.this.scheduledSignals.remove(finalSignalId);
                        if (scheduled == null) {
                            throw new IllegalArgumentException("Signal \"" + finalSignalId + "\" wasn't scheduled");
                        }
                        handle.complete();
                    }
                };
            }
        }.setName(taskName);
        context.setResultDescription("signalWorkflowExecution " + taskName);
        return context.getResult();
    }

    @Override
    public void requestCancelWorkflowExecution(WorkflowExecution execution) {
        RequestCancelExternalWorkflowExecutionDecisionAttributes attributes = (RequestCancelExternalWorkflowExecutionDecisionAttributes)RequestCancelExternalWorkflowExecutionDecisionAttributes.builder().workflowId(this.decisions.getActualChildWorkflowId(execution.getWorkflowId())).runId(execution.getRunId()).build();
        this.decisions.requestCancelExternalWorkflowExecution(attributes, null);
    }

    @Override
    public void continueAsNewOnCompletion(ContinueAsNewWorkflowExecutionParameters continueParameters) {
        this.workflowContext.setContinueAsNewOnCompletion(continueParameters);
    }

    @Override
    public String generateUniqueId() {
        return this.decisions.getChildWorkflowIdHandler().generateWorkflowId(this.workflowContext.getWorkflowExecution(), this.decisions::getNextId);
    }

    public void handleChildWorkflowExecutionCancelRequested(HistoryEvent event) {
        this.decisions.handleChildWorkflowExecutionCancelRequested(event);
    }

    void handleChildWorkflowExecutionCanceled(HistoryEvent event) {
        OpenRequestInfo<StartChildWorkflowReply, WorkflowType> scheduled;
        ChildWorkflowExecutionCanceledEventAttributes attributes = event.childWorkflowExecutionCanceledEventAttributes();
        WorkflowExecution execution = WorkflowExecution.fromSdkType(attributes.workflowExecution());
        String workflowId = execution.getWorkflowId();
        if (this.decisions.handleChildWorkflowExecutionCanceled(workflowId) && (scheduled = this.scheduledExternalWorkflows.remove(workflowId)) != null) {
            CancellationException e = new CancellationException();
            ExternalTaskCompletionHandle completionHandle = scheduled.getCompletionHandle();
            completionHandle.fail(e);
        }
    }

    void handleChildWorkflowExecutionInitiated(HistoryEvent event) {
        String requestedWorkflowId;
        String actualWorkflowId = event.startChildWorkflowExecutionInitiatedEventAttributes().workflowId();
        if (!actualWorkflowId.equals(requestedWorkflowId = this.decisions.getChildWorkflowIdHandler().extractRequestedWorkflowId(actualWorkflowId))) {
            OpenRequestInfo<StartChildWorkflowReply, WorkflowType> scheduled = this.scheduledExternalWorkflows.remove(requestedWorkflowId);
            this.scheduledExternalWorkflows.put(actualWorkflowId, scheduled);
        }
        this.decisions.handleStartChildWorkflowExecutionInitiated(event);
    }

    void handleChildWorkflowExecutionStarted(HistoryEvent event) {
        ChildWorkflowExecutionStartedEventAttributes attributes = event.childWorkflowExecutionStartedEventAttributes();
        String workflowId = attributes.workflowExecution().workflowId();
        this.decisions.handleChildWorkflowExecutionStarted(event);
        OpenRequestInfo<StartChildWorkflowReply, WorkflowType> scheduled = this.scheduledExternalWorkflows.get(workflowId);
        if (scheduled != null) {
            String runId = attributes.workflowExecution().runId();
            Settable<StartChildWorkflowReply> result = scheduled.getResult();
            if (!result.isReady()) {
                String description = "startChildWorkflow workflowId=" + workflowId + ", runId=" + runId;
                result.set(new StartChildWorkflowReplyImpl(workflowId, runId, description));
            }
        }
    }

    void handleChildWorkflowExecutionTimedOut(HistoryEvent event) {
        OpenRequestInfo<StartChildWorkflowReply, WorkflowType> scheduled;
        ChildWorkflowExecutionTimedOutEventAttributes attributes = event.childWorkflowExecutionTimedOutEventAttributes();
        WorkflowExecution execution = WorkflowExecution.fromSdkType(attributes.workflowExecution());
        String workflowId = attributes.workflowExecution().workflowId();
        if (this.decisions.handleChildWorkflowExecutionClosed(workflowId) && (scheduled = this.scheduledExternalWorkflows.remove(workflowId)) != null) {
            ChildWorkflowTimedOutException failure = new ChildWorkflowTimedOutException(event.eventId(), execution, WorkflowType.fromSdkType(attributes.workflowType()));
            ExternalTaskCompletionHandle context = scheduled.getCompletionHandle();
            context.fail(failure);
        }
    }

    void handleChildWorkflowExecutionTerminated(HistoryEvent event) {
        OpenRequestInfo<StartChildWorkflowReply, WorkflowType> scheduled;
        ChildWorkflowExecutionTerminatedEventAttributes attributes = event.childWorkflowExecutionTerminatedEventAttributes();
        WorkflowExecution execution = WorkflowExecution.fromSdkType(attributes.workflowExecution());
        String workflowId = attributes.workflowExecution().workflowId();
        if (this.decisions.handleChildWorkflowExecutionClosed(workflowId) && (scheduled = this.scheduledExternalWorkflows.remove(workflowId)) != null) {
            ChildWorkflowTerminatedException failure = new ChildWorkflowTerminatedException(event.eventId(), execution, WorkflowType.fromSdkType(attributes.workflowType()));
            ExternalTaskCompletionHandle context = scheduled.getCompletionHandle();
            context.fail(failure);
        }
    }

    void handleStartChildWorkflowExecutionFailed(HistoryEvent event) {
        if (this.decisions.handleStartChildWorkflowExecutionFailed(event)) {
            StartChildWorkflowExecutionFailedEventAttributes attributes = event.startChildWorkflowExecutionFailedEventAttributes();
            String actualWorkflowId = attributes.workflowId();
            String requestedWorkflowId = this.decisions.getChildWorkflowIdHandler().extractRequestedWorkflowId(actualWorkflowId);
            String workflowId = null;
            OpenRequestInfo<StartChildWorkflowReply, WorkflowType> scheduled = null;
            if (this.scheduledExternalWorkflows.containsKey(requestedWorkflowId)) {
                scheduled = this.scheduledExternalWorkflows.remove(requestedWorkflowId);
                workflowId = requestedWorkflowId;
            } else if (this.scheduledExternalWorkflows.containsKey(actualWorkflowId)) {
                scheduled = this.scheduledExternalWorkflows.remove(actualWorkflowId);
                workflowId = actualWorkflowId;
            }
            if (scheduled != null) {
                WorkflowExecution workflowExecution = WorkflowExecution.builder().workflowId(workflowId).build();
                WorkflowType workflowType = WorkflowType.fromSdkType(attributes.workflowType());
                String cause = attributes.causeAsString();
                StartChildWorkflowFailedException failure = new StartChildWorkflowFailedException(event.eventId(), workflowExecution, workflowType, cause);
                ExternalTaskCompletionHandle context = scheduled.getCompletionHandle();
                context.fail(failure);
            }
        }
    }

    void handleChildWorkflowExecutionFailed(HistoryEvent event) {
        OpenRequestInfo<StartChildWorkflowReply, WorkflowType> scheduled;
        ChildWorkflowExecutionFailedEventAttributes attributes = event.childWorkflowExecutionFailedEventAttributes();
        WorkflowExecution execution = WorkflowExecution.fromSdkType(attributes.workflowExecution());
        String workflowId = execution.getWorkflowId();
        if (this.decisions.handleChildWorkflowExecutionClosed(workflowId) && (scheduled = this.scheduledExternalWorkflows.remove(workflowId)) != null) {
            String reason = attributes.reason();
            String details = attributes.details();
            ChildWorkflowFailedException failure = new ChildWorkflowFailedException(event.eventId(), execution, WorkflowType.fromSdkType(attributes.workflowType()), reason, details);
            ExternalTaskCompletionHandle context = scheduled.getCompletionHandle();
            context.fail(failure);
        }
    }

    void handleChildWorkflowExecutionCompleted(HistoryEvent event) {
        OpenRequestInfo<StartChildWorkflowReply, WorkflowType> scheduled;
        ChildWorkflowExecutionCompletedEventAttributes attributes = event.childWorkflowExecutionCompletedEventAttributes();
        String workflowId = attributes.workflowExecution().workflowId();
        if (this.decisions.handleChildWorkflowExecutionClosed(workflowId) && (scheduled = this.scheduledExternalWorkflows.remove(workflowId)) != null) {
            ExternalTaskCompletionHandle context = scheduled.getCompletionHandle();
            String result = attributes.result();
            StartChildWorkflowReplyImpl startedReply = (StartChildWorkflowReplyImpl)scheduled.getResult().get();
            startedReply.setResult(result);
            context.complete();
        }
    }

    void handleSignalExternalWorkflowExecutionFailed(HistoryEvent event) {
        OpenRequestInfo<Void, Void> signalContextAndResult;
        SignalExternalWorkflowExecutionFailedEventAttributes attributes = event.signalExternalWorkflowExecutionFailedEventAttributes();
        String signalId = attributes.control();
        if (this.decisions.handleSignalExternalWorkflowExecutionFailed(signalId) && (signalContextAndResult = this.scheduledSignals.remove(signalId)) != null) {
            WorkflowExecution signaledExecution = WorkflowExecution.builder().workflowId(attributes.workflowId()).runId(attributes.runId()).build();
            SignalExternalWorkflowException failure = new SignalExternalWorkflowException(event.eventId(), signaledExecution, attributes.causeAsString());
            signalContextAndResult.getCompletionHandle().fail(failure);
        }
    }

    void handleExternalWorkflowExecutionSignaled(HistoryEvent event) {
        OpenRequestInfo<Void, Void> signalContextAndResult;
        ExternalWorkflowExecutionSignaledEventAttributes attributes = event.externalWorkflowExecutionSignaledEventAttributes();
        String signalId = this.decisions.getSignalIdFromExternalWorkflowExecutionSignaled(attributes.initiatedEventId());
        if (this.decisions.handleExternalWorkflowExecutionSignaled(signalId) && (signalContextAndResult = this.scheduledSignals.remove(signalId)) != null) {
            signalContextAndResult.getResult().set(null);
            signalContextAndResult.getCompletionHandle().complete();
        }
    }

    private final class ChildWorkflowCancellationHandler
    implements ExternalTaskCancellationHandler {
        private final String requestedWorkflowId;
        private final ExternalTaskCompletionHandle handle;

        private ChildWorkflowCancellationHandler(String requestedWorkflowId, ExternalTaskCompletionHandle handle) {
            this.requestedWorkflowId = requestedWorkflowId;
            this.handle = handle;
        }

        @Override
        public void handleCancellation(Throwable cause) {
            final String actualWorkflowId = GenericWorkflowClientImpl.this.decisions.getActualChildWorkflowId(this.requestedWorkflowId);
            RequestCancelExternalWorkflowExecutionDecisionAttributes cancelAttributes = (RequestCancelExternalWorkflowExecutionDecisionAttributes)RequestCancelExternalWorkflowExecutionDecisionAttributes.builder().workflowId(actualWorkflowId).build();
            GenericWorkflowClientImpl.this.decisions.requestCancelExternalWorkflowExecution(cancelAttributes, new Runnable(){

                @Override
                public void run() {
                    OpenRequestInfo scheduled = (OpenRequestInfo)GenericWorkflowClientImpl.this.scheduledExternalWorkflows.remove(actualWorkflowId);
                    if (scheduled == null) {
                        throw new IllegalArgumentException("Workflow \"" + actualWorkflowId + "\" wasn't scheduled");
                    }
                    ChildWorkflowCancellationHandler.this.handle.complete();
                }
            });
        }
    }

    private static class StartChildWorkflowReplyImpl
    implements StartChildWorkflowReply {
        private String workflowId;
        private String runId;
        private final Settable<String> result = new Settable();

        public StartChildWorkflowReplyImpl(String workflowId, String runId, String description) {
            this.runId = runId;
            this.workflowId = workflowId;
            this.result.setDescription(description);
        }

        @Override
        public String getWorkflowId() {
            return this.workflowId;
        }

        @Override
        public String getRunId() {
            return this.runId;
        }

        @Override
        public Promise<String> getResult() {
            return this.result;
        }

        public void setResult(String value) {
            this.result.set(value);
        }
    }
}

