/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.common.FlowHelpers;
import com.amazonaws.services.simpleworkflow.flow.common.RequestTimeoutHelper;
import com.amazonaws.services.simpleworkflow.flow.config.SimpleWorkflowClientConfig;
import com.amazonaws.services.simpleworkflow.flow.generic.GenericWorkflowClientExternal;
import com.amazonaws.services.simpleworkflow.flow.generic.SignalExternalWorkflowParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.StartWorkflowExecutionParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.TerminateWorkflowExecutionParameters;
import com.amazonaws.services.simpleworkflow.flow.model.WorkflowExecution;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import software.amazon.awssdk.services.swf.SwfClient;
import software.amazon.awssdk.services.swf.model.DescribeWorkflowExecutionRequest;
import software.amazon.awssdk.services.swf.model.DescribeWorkflowExecutionResponse;
import software.amazon.awssdk.services.swf.model.RequestCancelWorkflowExecutionRequest;
import software.amazon.awssdk.services.swf.model.SignalWorkflowExecutionRequest;
import software.amazon.awssdk.services.swf.model.StartWorkflowExecutionRequest;
import software.amazon.awssdk.services.swf.model.StartWorkflowExecutionResponse;
import software.amazon.awssdk.services.swf.model.TaskList;
import software.amazon.awssdk.services.swf.model.TerminateWorkflowExecutionRequest;

public class GenericWorkflowClientExternalImpl
implements GenericWorkflowClientExternal {
    private final String domain;
    private final SwfClient service;
    private SimpleWorkflowClientConfig config;

    public GenericWorkflowClientExternalImpl(SwfClient service, String domain) {
        this(service, domain, null);
    }

    public GenericWorkflowClientExternalImpl(SwfClient service, String domain, SimpleWorkflowClientConfig config) {
        this.service = service;
        this.domain = domain;
        this.config = config;
    }

    @Override
    public WorkflowExecution startWorkflow(StartWorkflowExecutionParameters startParameters) {
        StartWorkflowExecutionRequest.Builder builderRequest = StartWorkflowExecutionRequest.builder().domain(this.domain).input(startParameters.getInput()).executionStartToCloseTimeout(FlowHelpers.secondsToDuration(startParameters.getExecutionStartToCloseTimeout())).taskStartToCloseTimeout(FlowHelpers.secondsToDuration(startParameters.getTaskStartToCloseTimeoutSeconds())).tagList(startParameters.getTagList()).workflowId(startParameters.getWorkflowId()).workflowType(startParameters.getWorkflowType().toSdkType()).taskPriority(FlowHelpers.taskPriorityToString(startParameters.getTaskPriority())).lambdaRole(startParameters.getLambdaRole());
        String taskList = startParameters.getTaskList();
        if (taskList != null && !taskList.isEmpty()) {
            builderRequest.taskList((TaskList)TaskList.builder().name(taskList).build());
        }
        if (startParameters.getChildPolicy() != null) {
            builderRequest.childPolicy(startParameters.getChildPolicy());
        }
        StartWorkflowExecutionRequest request = (StartWorkflowExecutionRequest)builderRequest.build();
        request = RequestTimeoutHelper.overrideDataPlaneRequestTimeout(request, this.config);
        StartWorkflowExecutionResponse result = this.service.startWorkflowExecution(request);
        return WorkflowExecution.builder().workflowId(request.workflowId()).runId(result.runId()).build();
    }

    @Override
    public void signalWorkflowExecution(SignalExternalWorkflowParameters signalParameters) {
        SignalWorkflowExecutionRequest request = (SignalWorkflowExecutionRequest)SignalWorkflowExecutionRequest.builder().domain(this.domain).input(signalParameters.getInput()).signalName(signalParameters.getSignalName()).runId(signalParameters.getRunId()).workflowId(signalParameters.getWorkflowId()).build();
        request = RequestTimeoutHelper.overrideDataPlaneRequestTimeout(request, this.config);
        this.service.signalWorkflowExecution(request);
    }

    @Override
    public void requestCancelWorkflowExecution(WorkflowExecution execution) {
        RequestCancelWorkflowExecutionRequest request = (RequestCancelWorkflowExecutionRequest)RequestCancelWorkflowExecutionRequest.builder().domain(this.domain).runId(execution.getRunId()).workflowId(execution.getWorkflowId()).build();
        request = RequestTimeoutHelper.overrideDataPlaneRequestTimeout(request, this.config);
        this.service.requestCancelWorkflowExecution(request);
    }

    @Override
    public String generateUniqueId() {
        return UUID.randomUUID().toString();
    }

    @Override
    public String getWorkflowState(WorkflowExecution execution) {
        String result;
        String executionContext = this.getLatestWorkflowExecutionContext(execution);
        if (executionContext != null && executionContext.startsWith("*component_version*")) {
            Scanner scanner = new Scanner(executionContext);
            scanner.useDelimiter("\n|\t");
            scanner.next();
            int size = scanner.nextInt();
            for (int i = 0; i < size; ++i) {
                scanner.next();
                scanner.nextInt();
            }
            result = scanner.next(".*");
        } else {
            result = executionContext;
        }
        return result;
    }

    @Override
    public Map<String, Integer> getImplementationVersions(WorkflowExecution execution) {
        String executionContext = this.getLatestWorkflowExecutionContext(execution);
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (executionContext.startsWith("*component_version*")) {
            Scanner scanner = new Scanner(executionContext);
            scanner.useDelimiter("\n|\t");
            scanner.next();
            int size = scanner.nextInt();
            for (int i = 0; i < size; ++i) {
                String componentName = scanner.next();
                int version = scanner.nextInt();
                result.put(componentName, version);
            }
        }
        return result;
    }

    private String getLatestWorkflowExecutionContext(WorkflowExecution execution) {
        DescribeWorkflowExecutionRequest request = (DescribeWorkflowExecutionRequest)DescribeWorkflowExecutionRequest.builder().domain(this.domain).execution(execution.toSdkType()).build();
        request = RequestTimeoutHelper.overrideDataPlaneRequestTimeout(request, this.config);
        DescribeWorkflowExecutionResponse details = this.service.describeWorkflowExecution(request);
        return details.latestExecutionContext();
    }

    @Override
    public void terminateWorkflowExecution(TerminateWorkflowExecutionParameters terminateParameters) {
        WorkflowExecution workflowExecution = terminateParameters.getWorkflowExecution();
        TerminateWorkflowExecutionRequest request = (TerminateWorkflowExecutionRequest)TerminateWorkflowExecutionRequest.builder().workflowId(workflowExecution.getWorkflowId()).runId(workflowExecution.getRunId()).domain(this.domain).details(terminateParameters.getDetails()).reason(terminateParameters.getReason()).childPolicy(terminateParameters.getChildPolicy()).build();
        request = RequestTimeoutHelper.overrideDataPlaneRequestTimeout(request, this.config);
        this.service.terminateWorkflowExecution(request);
    }
}

