/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.config.SimpleWorkflowClientConfig;
import com.amazonaws.services.simpleworkflow.flow.worker.AffinityHelper;
import com.amazonaws.services.simpleworkflow.flow.worker.AsyncDecisionTaskHandler;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionTaskPoller;
import com.amazonaws.services.simpleworkflow.flow.worker.GenericWorkflowWorker;
import com.amazonaws.services.simpleworkflow.flow.worker.TaskPoller;
import software.amazon.awssdk.services.swf.SwfClient;

public class GenericAffinityWorkflowWorker
extends GenericWorkflowWorker {
    public static final String AFFINITY_THREAD_NAME_PREFIX = "SWF Affinity Decider ";
    private final AffinityHelper affinityHelper;

    public GenericAffinityWorkflowWorker(SwfClient service, String domain, SimpleWorkflowClientConfig config) {
        if (config.getDeciderAffinityConfig() == null) {
            throw new IllegalStateException("Trying to create an affinity worker while decider affinity config is not provided");
        }
        this.setService(service);
        this.setDomain(domain);
        this.affinityHelper = new AffinityHelper(this.getService(), this.getDomain(), config, true);
        this.setTaskListToPoll(this.affinityHelper.getAffinityTaskList());
        this.setClientConfig(config);
    }

    @Override
    protected TaskPoller<DecisionTaskPoller.DecisionTaskIterator> createPoller() {
        DecisionTaskPoller result = (DecisionTaskPoller)super.createPoller();
        AsyncDecisionTaskHandler decisionTaskHandler = new AsyncDecisionTaskHandler(this.workflowDefinitionFactoryFactory, this.childWorkflowIdHandler, this.affinityHelper, this.getClientConfig());
        result.setDecisionTaskHandler(decisionTaskHandler);
        return result;
    }

    @Override
    protected String getPollThreadNamePrefix() {
        return AFFINITY_THREAD_NAME_PREFIX + this.getTaskListToPoll();
    }
}

