/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.config.SimpleWorkflowClientConfig;
import com.amazonaws.services.simpleworkflow.flow.worker.BackoffThrottlerWithJitter;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionId;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionState;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionStateMachineBase;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionTarget;
import software.amazon.awssdk.services.swf.model.Decision;
import software.amazon.awssdk.services.swf.model.DecisionType;
import software.amazon.awssdk.services.swf.model.HistoryEvent;
import software.amazon.awssdk.services.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes;
import software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionDecisionAttributes;

class ChildWorkflowDecisionStateMachine
extends DecisionStateMachineBase {
    private final StartChildWorkflowExecutionDecisionAttributes startAttributes;
    private String workflowId;
    private SimpleWorkflowClientConfig clientConfig;
    private BackoffThrottlerWithJitter throttler;

    public ChildWorkflowDecisionStateMachine(DecisionId id, StartChildWorkflowExecutionDecisionAttributes startAttributes, SimpleWorkflowClientConfig clientConfig) {
        super(id);
        this.startAttributes = startAttributes;
        this.workflowId = startAttributes.workflowId();
        this.clientConfig = clientConfig;
        this.throttler = new BackoffThrottlerWithJitter(clientConfig.getInitialSleepForDecisionThrottleInMillis(), clientConfig.getMaxSleepForDecisionThrottleInMillis(), clientConfig.getBackoffCoefficientForDecisionThrottle());
    }

    ChildWorkflowDecisionStateMachine(DecisionId id, StartChildWorkflowExecutionDecisionAttributes startAttributes, DecisionState state, SimpleWorkflowClientConfig clientConfig) {
        super(id, state);
        this.startAttributes = startAttributes;
        this.workflowId = startAttributes.workflowId();
        this.clientConfig = clientConfig;
        this.throttler = new BackoffThrottlerWithJitter(clientConfig.getInitialSleepForDecisionThrottleInMillis(), clientConfig.getMaxSleepForDecisionThrottleInMillis(), clientConfig.getBackoffCoefficientForDecisionThrottle());
    }

    @Override
    public Decision getDecision() {
        switch (this.state) {
            case CREATED: {
                return this.createStartChildWorkflowExecutionDecision();
            }
            case CANCELED_AFTER_STARTED: {
                return this.createRequestCancelExternalWorkflowExecutionDecision();
            }
        }
        return null;
    }

    @Override
    public void throttleDecision() {
        try {
            this.throttler.throttle();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void handleDecisionTaskStartedEvent() {
        switch (this.state) {
            case CANCELED_AFTER_STARTED: {
                this.state = DecisionState.CANCELLATION_DECISION_SENT;
                break;
            }
            default: {
                super.handleDecisionTaskStartedEvent();
            }
        }
    }

    @Override
    public void handleInitiatedEvent(HistoryEvent event) {
        String actualWorkflowId = event.startChildWorkflowExecutionInitiatedEventAttributes().workflowId();
        if (!this.workflowId.equals(actualWorkflowId)) {
            this.workflowId = actualWorkflowId;
            this.id = new DecisionId(DecisionTarget.EXTERNAL_WORKFLOW, actualWorkflowId);
        }
        super.handleInitiatedEvent(event);
    }

    @Override
    public void handleInitiationFailedEvent(HistoryEvent event) {
        String actualWorkflowId = event.startChildWorkflowExecutionFailedEventAttributes().workflowId();
        if (!this.workflowId.equals(actualWorkflowId)) {
            this.workflowId = actualWorkflowId;
            this.id = new DecisionId(DecisionTarget.EXTERNAL_WORKFLOW, actualWorkflowId);
        }
        super.handleInitiationFailedEvent(event);
    }

    @Override
    public void handleStartedEvent(HistoryEvent event) {
        this.stateHistory.add("handleStartedEvent");
        switch (this.state) {
            case INITIATED: {
                this.state = DecisionState.STARTED;
                break;
            }
            case CANCELED_AFTER_INITIATED: {
                this.state = DecisionState.CANCELED_AFTER_STARTED;
            }
        }
        this.stateHistory.add(this.state.toString());
    }

    @Override
    public void handleCancellationFailureEvent(HistoryEvent event) {
        switch (this.state) {
            case CANCELLATION_DECISION_SENT: {
                this.stateHistory.add("handleCancellationFailureEvent");
                if (this.throttler.getFailureCount() < (long)this.clientConfig.getMaxRetryForCancelingExternalWorkflow()) {
                    this.throttler.failure();
                    this.state = DecisionState.CANCELED_AFTER_STARTED;
                } else {
                    this.state = DecisionState.STARTED;
                }
                this.stateHistory.add(this.state.toString());
                break;
            }
            default: {
                super.handleCancellationFailureEvent(event);
            }
        }
    }

    @Override
    public void cancel(Runnable immediateCancellationCallback) {
        switch (this.state) {
            case STARTED: {
                this.stateHistory.add("cancel");
                this.state = DecisionState.CANCELED_AFTER_STARTED;
                this.stateHistory.add(this.state.toString());
                break;
            }
            default: {
                super.cancel(immediateCancellationCallback);
            }
        }
    }

    @Override
    public void handleCancellationEvent() {
        switch (this.state) {
            case STARTED: {
                this.stateHistory.add("handleCancellationEvent");
                this.state = DecisionState.COMPLETED;
                this.stateHistory.add(this.state.toString());
                break;
            }
            default: {
                super.handleCancellationEvent();
            }
        }
    }

    @Override
    public void handleCompletionEvent() {
        switch (this.state) {
            case CANCELED_AFTER_STARTED: 
            case STARTED: 
            case COMPLETED: {
                this.stateHistory.add("handleCompletionEvent");
                this.state = DecisionState.COMPLETED;
                this.stateHistory.add(this.state.toString());
                break;
            }
            default: {
                super.handleCompletionEvent();
            }
        }
    }

    private Decision createRequestCancelExternalWorkflowExecutionDecision() {
        RequestCancelExternalWorkflowExecutionDecisionAttributes tryCancel = (RequestCancelExternalWorkflowExecutionDecisionAttributes)RequestCancelExternalWorkflowExecutionDecisionAttributes.builder().workflowId(this.workflowId).build();
        return (Decision)Decision.builder().requestCancelExternalWorkflowExecutionDecisionAttributes(tryCancel).decisionType(DecisionType.REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION).build();
    }

    private Decision createStartChildWorkflowExecutionDecision() {
        return (Decision)Decision.builder().startChildWorkflowExecutionDecisionAttributes(this.startAttributes).decisionType(DecisionType.START_CHILD_WORKFLOW_EXECUTION).build();
    }
}

