/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.generic;

import com.amazonaws.services.simpleworkflow.flow.ActivitySchedulingOptions;
import com.amazonaws.services.simpleworkflow.flow.model.ActivityType;

public class ExecuteActivityParameters
implements Cloneable {
    private String activityId;
    private ActivityType activityType;
    private String control;
    private long heartbeatTimeoutSeconds = -2L;
    private String input;
    private long scheduleToCloseTimeoutSeconds = -2L;
    private long scheduleToStartTimeoutSeconds = -2L;
    private long startToCloseTimeoutSeconds = -2L;
    private String taskList;
    private int taskPriority;

    public String getControl() {
        return this.control;
    }

    public void setControl(String control) {
        this.control = control;
    }

    public ExecuteActivityParameters withControl(String control) {
        this.control = control;
        return this;
    }

    public ActivityType getActivityType() {
        return this.activityType;
    }

    public void setActivityType(ActivityType activityType) {
        this.activityType = activityType;
    }

    public ExecuteActivityParameters withActivityType(ActivityType activityType) {
        this.activityType = activityType;
        return this;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public ExecuteActivityParameters withActivityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public ExecuteActivityParameters withInput(String input) {
        this.input = input;
        return this;
    }

    public long getHeartbeatTimeoutSeconds() {
        return this.heartbeatTimeoutSeconds;
    }

    public void setHeartbeatTimeoutSeconds(long heartbeatTimeoutSeconds) {
        this.heartbeatTimeoutSeconds = heartbeatTimeoutSeconds;
    }

    public ExecuteActivityParameters withHeartbeatTimeoutSeconds(long heartbeatTimeoutSeconds) {
        this.heartbeatTimeoutSeconds = heartbeatTimeoutSeconds;
        return this;
    }

    public long getScheduleToStartTimeoutSeconds() {
        return this.scheduleToStartTimeoutSeconds;
    }

    public void setScheduleToStartTimeoutSeconds(long scheduleToStartTimeoutSeconds) {
        this.scheduleToStartTimeoutSeconds = scheduleToStartTimeoutSeconds;
    }

    public ExecuteActivityParameters withScheduleToStartTimeoutSeconds(long scheduleToStartTimeoutSeconds) {
        this.scheduleToStartTimeoutSeconds = scheduleToStartTimeoutSeconds;
        return this;
    }

    public long getScheduleToCloseTimeoutSeconds() {
        return this.scheduleToCloseTimeoutSeconds;
    }

    public void setScheduleToCloseTimeoutSeconds(long scheduleToCloseTimeoutSeconds) {
        this.scheduleToCloseTimeoutSeconds = scheduleToCloseTimeoutSeconds;
    }

    public ExecuteActivityParameters withScheduleToCloseTimeoutSeconds(long scheduleToCloseTimeoutSeconds) {
        this.scheduleToCloseTimeoutSeconds = scheduleToCloseTimeoutSeconds;
        return this;
    }

    public long getStartToCloseTimeoutSeconds() {
        return this.startToCloseTimeoutSeconds;
    }

    public void setStartToCloseTimeoutSeconds(long startToCloseTimeoutSeconds) {
        this.startToCloseTimeoutSeconds = startToCloseTimeoutSeconds;
    }

    public ExecuteActivityParameters withStartToCloseTimeoutSeconds(long startToCloseTimeoutSeconds) {
        this.startToCloseTimeoutSeconds = startToCloseTimeoutSeconds;
        return this;
    }

    public String getTaskList() {
        return this.taskList;
    }

    public void setTaskList(String taskList) {
        this.taskList = taskList;
    }

    public ExecuteActivityParameters withTaskList(String taskList) {
        this.taskList = taskList;
        return this;
    }

    public int getTaskPriority() {
        return this.taskPriority;
    }

    public void setTaskPriority(int taskPriority) {
        this.taskPriority = taskPriority;
    }

    public ExecuteActivityParameters withTaskPriority(int taskPriority) {
        this.taskPriority = taskPriority;
        return this;
    }

    public ExecuteActivityParameters createExecuteActivityParametersFromOptions(ActivitySchedulingOptions options, ActivitySchedulingOptions optionsOverride) {
        Integer taskPriority;
        String taskList;
        Long startToCloseTimeoutSeconds;
        Long scheduleToStartTimeout;
        Long scheduleToCloseTimeout;
        Long heartbeatTimeoutSeconds;
        ExecuteActivityParameters scheduleActivityParameters = this.clone();
        if (options != null) {
            heartbeatTimeoutSeconds = options.getHeartbeatTimeoutSeconds();
            if (heartbeatTimeoutSeconds != null) {
                scheduleActivityParameters.setHeartbeatTimeoutSeconds(heartbeatTimeoutSeconds);
            }
            if ((scheduleToCloseTimeout = options.getScheduleToCloseTimeoutSeconds()) != null) {
                scheduleActivityParameters.setScheduleToCloseTimeoutSeconds(scheduleToCloseTimeout);
            }
            if ((scheduleToStartTimeout = options.getScheduleToStartTimeoutSeconds()) != null) {
                scheduleActivityParameters.setScheduleToStartTimeoutSeconds(scheduleToStartTimeout);
            }
            if ((startToCloseTimeoutSeconds = options.getStartToCloseTimeoutSeconds()) != null) {
                scheduleActivityParameters.setStartToCloseTimeoutSeconds(startToCloseTimeoutSeconds);
            }
            if ((taskList = options.getTaskList()) != null && !taskList.isEmpty()) {
                scheduleActivityParameters.setTaskList(taskList);
            }
            if ((taskPriority = options.getTaskPriority()) != null) {
                scheduleActivityParameters.setTaskPriority(taskPriority);
            }
        }
        if (optionsOverride != null) {
            heartbeatTimeoutSeconds = optionsOverride.getHeartbeatTimeoutSeconds();
            if (heartbeatTimeoutSeconds != null) {
                scheduleActivityParameters.setHeartbeatTimeoutSeconds(heartbeatTimeoutSeconds);
            }
            if ((scheduleToCloseTimeout = optionsOverride.getScheduleToCloseTimeoutSeconds()) != null) {
                scheduleActivityParameters.setScheduleToCloseTimeoutSeconds(scheduleToCloseTimeout);
            }
            if ((scheduleToStartTimeout = optionsOverride.getScheduleToStartTimeoutSeconds()) != null) {
                scheduleActivityParameters.setScheduleToStartTimeoutSeconds(scheduleToStartTimeout);
            }
            if ((startToCloseTimeoutSeconds = optionsOverride.getStartToCloseTimeoutSeconds()) != null) {
                scheduleActivityParameters.setStartToCloseTimeoutSeconds(startToCloseTimeoutSeconds);
            }
            if ((taskList = optionsOverride.getTaskList()) != null && !taskList.isEmpty()) {
                scheduleActivityParameters.setTaskList(taskList);
            }
            if ((taskPriority = optionsOverride.getTaskPriority()) != null) {
                scheduleActivityParameters.setTaskPriority(taskPriority);
            }
        }
        return scheduleActivityParameters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("ActivityType: " + this.activityType + ", ");
        sb.append("ActivityId: " + this.activityId + ", ");
        sb.append("Input: " + this.input + ", ");
        sb.append("Control: " + this.control + ", ");
        sb.append("HeartbeatTimeout: " + this.heartbeatTimeoutSeconds + ", ");
        sb.append("ScheduleToStartTimeout: " + this.scheduleToStartTimeoutSeconds + ", ");
        sb.append("ScheduleToCloseTimeout: " + this.scheduleToCloseTimeoutSeconds + ", ");
        sb.append("StartToCloseTimeout: " + this.startToCloseTimeoutSeconds + ", ");
        sb.append("TaskList: " + this.taskList + ", ");
        sb.append("TaskPriority: " + this.taskPriority);
        sb.append("}");
        return sb.toString();
    }

    public ExecuteActivityParameters clone() {
        ExecuteActivityParameters result = new ExecuteActivityParameters();
        result.setActivityType(this.activityType);
        result.setActivityId(this.activityId);
        result.setInput(this.input);
        result.setControl(this.control);
        result.setHeartbeatTimeoutSeconds(this.heartbeatTimeoutSeconds);
        result.setScheduleToStartTimeoutSeconds(this.scheduleToStartTimeoutSeconds);
        result.setScheduleToCloseTimeoutSeconds(this.scheduleToCloseTimeoutSeconds);
        result.setStartToCloseTimeoutSeconds(this.startToCloseTimeoutSeconds);
        result.setTaskList(this.taskList);
        result.setTaskPriority(this.taskPriority);
        return result;
    }
}

