/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.generic;

import com.amazonaws.services.simpleworkflow.flow.StartWorkflowOptions;
import java.util.List;
import software.amazon.awssdk.services.swf.model.ChildPolicy;

public class ContinueAsNewWorkflowExecutionParameters {
    private String workflowTypeVersion;
    private long executionStartToCloseTimeoutSeconds = -2L;
    private String input;
    private List<String> tagList;
    private String taskList;
    private long taskStartToCloseTimeoutSeconds = -2L;
    private ChildPolicy childPolicy;
    private int taskPriority;
    private String lambdaRole;

    public String getWorkflowTypeVersion() {
        return this.workflowTypeVersion;
    }

    public void setWorkflowTypeVersion(String workflowTypeVersion) {
        this.workflowTypeVersion = workflowTypeVersion;
    }

    public ChildPolicy getChildPolicy() {
        return this.childPolicy;
    }

    public void setChildPolicy(ChildPolicy childPolicy) {
        this.childPolicy = childPolicy;
    }

    public long getExecutionStartToCloseTimeoutSeconds() {
        return this.executionStartToCloseTimeoutSeconds;
    }

    public void setExecutionStartToCloseTimeoutSeconds(long executionStartToCloseTimeoutSeconds) {
        this.executionStartToCloseTimeoutSeconds = executionStartToCloseTimeoutSeconds;
    }

    public ContinueAsNewWorkflowExecutionParameters withExecutionStartToCloseTimeoutSeconds(long executionStartToCloseTimeoutSeconds) {
        this.executionStartToCloseTimeoutSeconds = executionStartToCloseTimeoutSeconds;
        return this;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public ContinueAsNewWorkflowExecutionParameters withInput(String input) {
        this.input = input;
        return this;
    }

    public List<String> getTagList() {
        return this.tagList;
    }

    public void setTagList(List<String> tagList) {
        this.tagList = tagList;
    }

    public ContinueAsNewWorkflowExecutionParameters withTagList(List<String> tagList) {
        this.tagList = tagList;
        return this;
    }

    public String getTaskList() {
        return this.taskList;
    }

    public void setTaskList(String taskList) {
        this.taskList = taskList;
    }

    public ContinueAsNewWorkflowExecutionParameters withTaskList(String taskList) {
        this.taskList = taskList;
        return this;
    }

    public int getTaskPriority() {
        return this.taskPriority;
    }

    public void setTaskPriority(int taskPriority) {
        this.taskPriority = taskPriority;
    }

    public ContinueAsNewWorkflowExecutionParameters withTaskPriority(int taskPriority) {
        this.taskPriority = taskPriority;
        return this;
    }

    public long getTaskStartToCloseTimeoutSeconds() {
        return this.taskStartToCloseTimeoutSeconds;
    }

    public void setTaskStartToCloseTimeoutSeconds(long taskStartToCloseTimeoutSeconds) {
        this.taskStartToCloseTimeoutSeconds = taskStartToCloseTimeoutSeconds;
    }

    public ContinueAsNewWorkflowExecutionParameters withTaskStartToCloseTimeoutSeconds(long taskStartToCloseTimeoutSeconds) {
        this.taskStartToCloseTimeoutSeconds = taskStartToCloseTimeoutSeconds;
        return this;
    }

    public String getLambdaRole() {
        return this.lambdaRole;
    }

    public void setLambdaRole(String lambdaRole) {
        this.lambdaRole = lambdaRole;
    }

    public ContinueAsNewWorkflowExecutionParameters withLambdaRole(String lambdaRole) {
        this.lambdaRole = lambdaRole;
        return this;
    }

    public ContinueAsNewWorkflowExecutionParameters createContinueAsNewParametersFromOptions(StartWorkflowOptions options, StartWorkflowOptions optionsOverride) {
        ContinueAsNewWorkflowExecutionParameters continueAsNewWorkflowExecutionParameters = this.clone();
        this.updateContinueAsNewWorkflowExecutionParameters(options, continueAsNewWorkflowExecutionParameters);
        this.updateContinueAsNewWorkflowExecutionParameters(optionsOverride, continueAsNewWorkflowExecutionParameters);
        return continueAsNewWorkflowExecutionParameters;
    }

    private void updateContinueAsNewWorkflowExecutionParameters(StartWorkflowOptions options, ContinueAsNewWorkflowExecutionParameters continueAsNewWorkflowExecutionParameters) {
        if (options != null) {
            String workflowTypeVersion;
            String lambdaRole;
            Integer taskPriority;
            ChildPolicy childPolicy;
            String taskList;
            List<String> tagList;
            Long taskStartToCloseTimeoutSeconds;
            Long executionStartToCloseTimeoutSeconds = options.getExecutionStartToCloseTimeoutSeconds();
            if (executionStartToCloseTimeoutSeconds != null) {
                continueAsNewWorkflowExecutionParameters.setExecutionStartToCloseTimeoutSeconds(executionStartToCloseTimeoutSeconds);
            }
            if ((taskStartToCloseTimeoutSeconds = options.getTaskStartToCloseTimeoutSeconds()) != null) {
                continueAsNewWorkflowExecutionParameters.setTaskStartToCloseTimeoutSeconds(taskStartToCloseTimeoutSeconds);
            }
            if ((tagList = options.getTagList()) != null) {
                continueAsNewWorkflowExecutionParameters.setTagList(tagList);
            }
            if ((taskList = options.getTaskList()) != null && !taskList.isEmpty()) {
                continueAsNewWorkflowExecutionParameters.setTaskList(taskList);
            }
            if ((childPolicy = options.getChildPolicy()) != null) {
                continueAsNewWorkflowExecutionParameters.setChildPolicy(childPolicy);
            }
            if ((taskPriority = options.getTaskPriority()) != null) {
                continueAsNewWorkflowExecutionParameters.setTaskPriority(taskPriority);
            }
            if ((lambdaRole = options.getLambdaRole()) != null) {
                continueAsNewWorkflowExecutionParameters.setLambdaRole(lambdaRole);
            }
            if ((workflowTypeVersion = options.getWorkflowTypeVersion()) != null && !workflowTypeVersion.trim().isEmpty()) {
                continueAsNewWorkflowExecutionParameters.setWorkflowTypeVersion(workflowTypeVersion);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("Input: " + this.input + ", ");
        sb.append("ExecutionStartToCloseTimeout: " + this.executionStartToCloseTimeoutSeconds + ", ");
        sb.append("TaskStartToCloseTimeout: " + this.taskStartToCloseTimeoutSeconds + ", ");
        sb.append("TagList: " + this.tagList + ", ");
        sb.append("TaskList: " + this.taskList + ", ");
        sb.append("TaskPriority: " + this.taskPriority + ", ");
        sb.append("LambdaRole: " + this.lambdaRole);
        sb.append("}");
        return sb.toString();
    }

    public ContinueAsNewWorkflowExecutionParameters clone() {
        ContinueAsNewWorkflowExecutionParameters result = new ContinueAsNewWorkflowExecutionParameters();
        result.setWorkflowTypeVersion(this.workflowTypeVersion);
        result.setExecutionStartToCloseTimeoutSeconds(this.executionStartToCloseTimeoutSeconds);
        result.setInput(this.input);
        result.setTagList(this.tagList);
        result.setTaskList(this.taskList);
        result.setTaskStartToCloseTimeoutSeconds(this.taskStartToCloseTimeoutSeconds);
        result.setChildPolicy(this.childPolicy);
        result.setTaskPriority(this.taskPriority);
        result.setLambdaRole(this.lambdaRole);
        return result;
    }
}

