/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.junit;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Task;
import org.junit.Assert;

public class AsyncAssert {
    protected AsyncAssert() {
    }

    public static void assertReady(String message, Promise<?> condition) {
        Assert.assertTrue((String)message, (boolean)condition.isReady());
    }

    public static void assertReady(Promise<?> condition) {
        Assert.assertTrue((boolean)condition.isReady());
    }

    public static void assertNotReady(String message, Promise<?> condition) {
        Assert.assertFalse((String)message, (boolean)condition.isReady());
    }

    public static void assertNotReady(Promise<?> condition) {
        Assert.assertFalse((boolean)condition.isReady());
    }

    public static void assertTrueWaitFor(final String message, final boolean condition, Promise<?> ... waitFor) {
        new Task((Promise[])waitFor){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertTrue((String)message, (boolean)condition);
            }
        };
    }

    public static void assertTrue(final String message, final Promise<Boolean> condition) {
        new Task(new Promise[]{condition}){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertTrue((String)message, (boolean)((Boolean)condition.get()));
            }
        };
    }

    public static void assertTrueWaitFor(final boolean condition, Promise<?> ... waitFor) {
        new Task((Promise[])waitFor){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertTrue((boolean)condition);
            }
        };
    }

    public static void assertTrue(final Promise<Boolean> condition) {
        new Task(new Promise[]{condition}){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertTrue((boolean)((Boolean)condition.get()));
            }
        };
    }

    public static void assertFalseWaitFor(final String message, final boolean condition, Promise<?> ... waitFor) {
        new Task((Promise[])waitFor){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertFalse((String)message, (boolean)condition);
            }
        };
    }

    public static void assertFalse(final String message, final Promise<Boolean> condition) {
        new Task(new Promise[]{condition}){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertFalse((String)message, (boolean)((Boolean)condition.get()));
            }
        };
    }

    public static void assertFalseWaitFor(final boolean condition, Promise<?> ... waitFor) {
        new Task((Promise[])waitFor){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertFalse((boolean)condition);
            }
        };
    }

    public static void assertFalse(final Promise<Boolean> condition) {
        new Task(new Promise[]{condition}){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertFalse((boolean)((Boolean)condition.get()));
            }
        };
    }

    public static void assertEquals(final String message, final Object expected, final Promise<?> actual) {
        new Task(new Promise[]{actual}){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertEquals((String)message, (Object)expected, actual.get());
            }
        };
    }

    public static void assertEqualsWaitFor(final String message, final Object expected, final Object actual, Promise<?> ... waitFor) {
        new Task((Promise[])waitFor){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertEquals((String)message, (Object)expected, (Object)actual);
            }
        };
    }

    public static void assertEquals(final Object expected, final Promise<?> actual) {
        new Task(new Promise[]{actual}){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertEquals((Object)expected, actual.get());
            }
        };
    }

    public static void assertEqualsWaitFor(final Object expected, final Object actual, Promise<?> ... waitFor) {
        new Task((Promise[])waitFor){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertEquals((Object)expected, (Object)actual);
            }
        };
    }

    public static void assertArrayEquals(final String message, final Object[] expected, final Object[] actual, Promise<?> ... waitFor) {
        new Task((Promise[])waitFor){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertArrayEquals((String)message, (Object[])expected, (Object[])actual);
            }
        };
    }

    public static void assertArrayEquals(final String message, final Object[] expected, final Promise<Object[]> actual) {
        new Task(new Promise[]{actual}){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertArrayEquals((String)message, (Object[])expected, (Object[])((Object[])actual.get()));
            }
        };
    }

    public static void assertArrayEqualsWaitFor(final Object[] expected, final Object[] actual, Promise<?> ... waitFor) {
        new Task((Promise[])waitFor){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertArrayEquals((Object[])expected, (Object[])actual);
            }
        };
    }

    public static void assertArrayEquals(final Object[] expected, final Promise<Object[]> actual) {
        new Task(new Promise[]{actual}){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertArrayEquals((Object[])expected, (Object[])((Object[])actual.get()));
            }
        };
    }

    public static void assertEqualsWaitFor(final String message, final double expected, final double actual, final double delta, Promise<?> ... waitFor) {
        new Task((Promise[])waitFor){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertEquals((String)message, (double)expected, (double)actual, (double)delta);
            }
        };
    }

    public static void assertEquals(final String message, final double expected, final Promise<Double> actual, final double delta) {
        new Task(new Promise[]{actual}){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertEquals((String)message, (double)expected, (double)((Double)actual.get()), (double)delta);
            }
        };
    }

    public static void assertEqualsWaitFor(final double expected, final double actual, final double delta, Promise<?> ... waitFor) {
        new Task((Promise[])waitFor){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertEquals((double)expected, (double)actual, (double)delta);
            }
        };
    }

    public static void assertEquals(final double expected, final Promise<Double> actual, final double delta) {
        new Task(new Promise[]{actual}){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertEquals((double)expected, (double)((Double)actual.get()), (double)delta);
            }
        };
    }

    public static void assertNotNullWaitFor(final String message, final Object object, Promise<?> ... waitFor) {
        new Task((Promise[])waitFor){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertNotNull((String)message, (Object)object);
            }
        };
    }

    public static void assertNotNull(final String message, final Promise<Object> object) {
        Assert.assertNotNull((String)message, object);
        new Task(new Promise[]{object}){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertNotNull((String)message, object.get());
            }
        };
    }

    public static void assertNotNullWaitFor(final Object object, Promise<?> ... waitFor) {
        new Task((Promise[])waitFor){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertNotNull((Object)object);
            }
        };
    }

    public static void assertNotNull(final Promise<Object> object) {
        Assert.assertNotNull(object);
        new Task(new Promise[]{object}){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertNotNull(object.get());
            }
        };
    }

    public static void assertNullWaitFor(final String message, final Object object, Promise<?> ... waitFor) {
        new Task((Promise[])waitFor){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertNull((String)message, (Object)object);
            }
        };
    }

    public static void assertNull(final String message, final Promise<Object> object) {
        Assert.assertNotNull(object);
        new Task(new Promise[]{object}){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertNull((String)message, object.get());
            }
        };
    }

    public static void assertNullWaitFor(final Object object, Promise<?> ... waitFor) {
        new Task((Promise[])waitFor){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertNull((Object)object);
            }
        };
    }

    public static void assertNull(final Promise<Object> object) {
        Assert.assertNotNull(object);
        new Task(new Promise[]{object}){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertNull(object.get());
            }
        };
    }

    public static void assertSameWaitFor(final String message, final Object expected, final Object actual, Promise<?> ... waitFor) {
        new Task((Promise[])waitFor){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertSame((String)message, (Object)expected, (Object)actual);
            }
        };
    }

    public static void assertSame(final String message, final Object expected, final Promise<Object> actual) {
        new Task(new Promise[]{actual}){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertSame((String)message, (Object)expected, actual.get());
            }
        };
    }

    public static void assertSameWaitFor(final Object expected, final Object actual, Promise<?> ... waitFor) {
        new Task((Promise[])waitFor){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertSame((Object)expected, (Object)actual);
            }
        };
    }

    public static void assertSame(final Object expected, final Promise<Object> actual) {
        new Task(new Promise[]{actual}){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertSame((Object)expected, actual.get());
            }
        };
    }

    public static void assertNotSameWaitFor(final String message, final Object expected, final Object actual, Promise<?> ... waitFor) {
        new Task((Promise[])waitFor){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertNotSame((String)message, (Object)expected, (Object)actual);
            }
        };
    }

    public static void assertNotSame(final String message, final Object expected, final Promise<Object> actual) {
        new Task(new Promise[]{actual}){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertNotSame((String)message, (Object)expected, actual.get());
            }
        };
    }

    public static void assertNotSameWaitFor(final Object expected, final Object actual, Promise<?> ... waitFor) {
        new Task((Promise[])waitFor){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertNotSame((Object)expected, (Object)actual);
            }
        };
    }

    public static void assertNotSame(final Object expected, final Promise<Object> actual) {
        new Task(new Promise[]{actual}){

            @Override
            protected void doExecute() throws Throwable {
                Assert.assertNotSame((Object)expected, actual.get());
            }
        };
    }
}

